/*
    KSocrat
    Version 3.1.2, 28 April 2003    
    (C) 2000-2003 Zavolzhsky Alexandr <zavolzhsky@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*/

#ifndef KSOCRAT_H
#define KSOCRAT_H

#include <kapp.h>
#include <kprocess.h>
#include <kmainwindow.h>
#include <qwidget.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include "sconfigure.h"

class KSocrat : public KMainWindow  {
   Q_OBJECT
public:
    KSocrat(const char *name=0);
    ~KSocrat();
    bool checkDicPath();
    void readConfig(bool bSetFont);
    void resizeEvent (QResizeEvent * );
    QString sRuEnDic,sEnRuDic,sDic,sWord;
    KShellProcess prGrep;	
    KConfig *config;
    SConfigure *sconfigure;
    bool bGrepFree;

protected: 
    void initDialog();
    QButtonGroup *bgTranslate;
    QRadioButton *rbEnglish;
    QRadioButton *rbRussian;
    KComboBox *edWord;
    QPushButton *btClear; 
    QPushButton *btTranslate;
    QMultiLineEdit *meResult;
    QPushButton *btSave;
    QPushButton *btConfigure;
    QPushButton *btAbout;
    QPushButton *btExit;
    QPushButton *btHide;
    QCheckBox *cbAutoLanguage;
    QCheckBox *cbKeepTrans;
    QCheckBox *cbSentTrans;
  
public slots:
  void translate();
  void save();
  void done();
  void configure();
  void about();
  void gotResult(KProcess *,char *msg,int);
  void gotError(KProcess *,char *msg,int);
  void quit();
  void clearall();
  void setKeepTransState();
  void saveHistory();
  void appClosing();
  void show_hide();
};

#endif
