#include <kdialog.h>
#include <klocale.h>
/****************************************************************************
** Form implementation generated from reading ui file './datawizard.ui'
**
** Created: Wed May 4 12:28:15 2005
**      by: The User Interface Compiler ()
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "datawizard.h"

#include <qvariant.h>
#include <kdialogbase.h>
#include <kmessagebox.h>
#include <knuminput.h>
#include <kiconloader.h>
#include <qguardedptr.h>
#include <qregexp.h>
#include <assert.h>
#include <stdlib.h>
#include <math.h>
#include <qdeepcopy.h>
#include <config.h>
#include <kurlcompletion.h>
#include <kdebug.h>
#include <qpushbutton.h>
#include <qwidget.h>
#include <qlabel.h>
#include <kurlrequester.h>
#include <qlineedit.h>
#include <qheader.h>
#include <qlistview.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qframe.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include "kstcolorsequence.h"
#include "kstvcurve.h"
#include "kstuinames.h"
#include "kstpsd.h"
#include "kstrvector.h"
#include "kstvectordefaults.h"
#include "kstviewwindow.h"
#include "kstcombobox.h"
#include "kstlegend.h"
#include "psversion.h"
#include "sysinfo.h"
#include "fftoptionswidget.h"
#include "datarangewidget.h"
#include "./datawizard.ui.h"
/*
 *  Constructs a DataWizard as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The wizard will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal wizard.
 */
DataWizard::DataWizard( QWidget* parent, const char* name, bool modal, WFlags fl )
    : KWizard( parent, name, modal, fl )
{
    if ( !name )
	setName( "DataWizard" );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)1, 0, 0, sizePolicy().hasHeightForWidth() ) );

    _pageDataSource = new QWidget( this, "_pageDataSource" );
    _pageDataSourceLayout = new QGridLayout( _pageDataSource, 1, 1, 11, 6, "_pageDataSourceLayout"); 

    textLabel2 = new QLabel( _pageDataSource, "textLabel2" );
    textLabel2->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop | QLabel::AlignHCenter ) );

    _pageDataSourceLayout->addMultiCellWidget( textLabel2, 0, 0, 0, 3 );
    spacer0 = new QSpacerItem( 31, 100, QSizePolicy::Minimum, QSizePolicy::Expanding );
    _pageDataSourceLayout->addItem( spacer0, 1, 1 );
    spacer1 = new QSpacerItem( 101, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    _pageDataSourceLayout->addItem( spacer1, 2, 0 );

    _url = new KURLRequester( _pageDataSource, "_url" );
    _url->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 3, 0, _url->sizePolicy().hasHeightForWidth() ) );

    _pageDataSourceLayout->addMultiCellWidget( _url, 2, 2, 1, 2 );
    spacer2 = new QSpacerItem( 71, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    _pageDataSourceLayout->addItem( spacer2, 2, 3 );
    unnamedLayout = new QHBoxLayout( 0, 0, 6, "unnamedLayout"); 

    _fileType = new QLabel( _pageDataSource, "_fileType" );
    _fileType->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop ) );
    _fileType->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 2, 0, _fileType->sizePolicy().hasHeightForWidth() ) );
    unnamedLayout->addWidget( _fileType );

    _testURL = new QPushButton( _pageDataSource, "_testURL" );
    _testURL->setHidden( TRUE );
    _testURL->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 0, 0, _testURL->sizePolicy().hasHeightForWidth() ) );
    unnamedLayout->addWidget( _testURL );

    _configureSource = new QPushButton( _pageDataSource, "_configureSource" );
    _configureSource->setEnabled( FALSE );
    _configureSource->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 0, 0, _configureSource->sizePolicy().hasHeightForWidth() ) );
    unnamedLayout->addWidget( _configureSource );

    _pageDataSourceLayout->addMultiCellLayout( unnamedLayout, 3, 3, 1, 2 );
    spacer5 = new QSpacerItem( 31, 170, QSizePolicy::Minimum, QSizePolicy::Expanding );
    _pageDataSourceLayout->addItem( spacer5, 4, 1 );
    addPage( _pageDataSource, QString("") );

    _pageVectors = new QWidget( this, "_pageVectors" );
    _pageVectorsLayout = new QGridLayout( _pageVectors, 1, 1, 11, 6, "_pageVectorsLayout"); 

    layout14 = new QGridLayout( 0, 1, 1, 0, 6, "layout14"); 

    _vectorReduction = new QLineEdit( _pageVectors, "_vectorReduction" );

    layout14->addMultiCellWidget( _vectorReduction, 0, 0, 0, 1 );

    _vectorSearch = new QPushButton( _pageVectors, "_vectorSearch" );
    _vectorSearch->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, _vectorSearch->sizePolicy().hasHeightForWidth() ) );

    layout14->addWidget( _vectorSearch, 0, 2 );

    _checkVectors = new QPushButton( _pageVectors, "_checkVectors" );

    layout14->addWidget( _checkVectors, 1, 0 );

    _uncheckAll = new QPushButton( _pageVectors, "_uncheckAll" );
    _uncheckAll->setEnabled( FALSE );

    layout14->addMultiCellWidget( _uncheckAll, 1, 1, 1, 2 );

    _vectors = new QListView( _pageVectors, "_vectors" );
    _vectors->addColumn( tr2i18n( "Field/Column" ) );
    _vectors->setResizePolicy( QListView::AutoOneFit );
    _vectors->setSelectionMode( QListView::Extended );
    _vectors->setShowSortIndicator( TRUE );

    layout14->addMultiCellWidget( _vectors, 2, 2, 0, 2 );

    _pageVectorsLayout->addLayout( layout14, 0, 0 );

    layout53 = new QVBoxLayout( 0, 0, 6, "layout53"); 

    _kstDataRange = new KstDataRange( _pageVectors, "_kstDataRange" );
    layout53->addWidget( _kstDataRange );

    buttonGroup5 = new QButtonGroup( _pageVectors, "buttonGroup5" );
    buttonGroup5->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, buttonGroup5->sizePolicy().hasHeightForWidth() ) );
    buttonGroup5->setColumnLayout(0, Qt::Vertical );
    buttonGroup5->layout()->setSpacing( 6 );
    buttonGroup5->layout()->setMargin( 11 );
    buttonGroup5Layout = new QGridLayout( buttonGroup5->layout() );
    buttonGroup5Layout->setAlignment( Qt::AlignTop );

    _radioButtonPlotDataPSD = new QRadioButton( buttonGroup5, "_radioButtonPlotDataPSD" );

    buttonGroup5Layout->addWidget( _radioButtonPlotDataPSD, 0, 2 );

    _radioButtonPlotData = new QRadioButton( buttonGroup5, "_radioButtonPlotData" );
    _radioButtonPlotData->setChecked( TRUE );

    buttonGroup5Layout->addWidget( _radioButtonPlotData, 0, 0 );

    _radioButtonPlotPSD = new QRadioButton( buttonGroup5, "_radioButtonPlotPSD" );

    buttonGroup5Layout->addWidget( _radioButtonPlotPSD, 0, 1 );

    line2 = new QFrame( buttonGroup5, "line2" );
    line2->setFrameShape( QFrame::HLine );
    line2->setFrameShadow( QFrame::Sunken );
    line2->setFrameShape( QFrame::HLine );

    buttonGroup5Layout->addMultiCellWidget( line2, 1, 1, 0, 2 );

    layout16 = new QHBoxLayout( 0, 0, 6, "layout16"); 

    _xvectLabel = new QLabel( buttonGroup5, "_xvectLabel" );
    _xvectLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)4, (QSizePolicy::SizeType)5, 0, 0, _xvectLabel->sizePolicy().hasHeightForWidth() ) );
    layout16->addWidget( _xvectLabel );

    _xVector = new KstComboBox( buttonGroup5, "_xVector" );
    _xVector->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, 1, 0, _xVector->sizePolicy().hasHeightForWidth() ) );
    _xVector->setEditable( TRUE );
    _xVector->setInsertionPolicy( KstComboBox::NoInsertion );
    _xVector->setAutoCompletion( TRUE );
    _xVector->setDuplicatesEnabled( FALSE );
    _xVector->setProperty( "urlDropsEnabled", QVariant( FALSE, 0 ) );
    layout16->addWidget( _xVector );

    buttonGroup5Layout->addMultiCellLayout( layout16, 2, 2, 0, 2 );
    layout53->addWidget( buttonGroup5 );

    _kstFFTOptions = new KstFFTOptions( _pageVectors, "_kstFFTOptions" );
    _kstFFTOptions->setEnabled( FALSE );
    layout53->addWidget( _kstFFTOptions );

    _applyFilters = new QCheckBox( _pageVectors, "_applyFilters" );
    _applyFilters->setEnabled( FALSE );
    layout53->addWidget( _applyFilters );

    _pageVectorsLayout->addLayout( layout53, 0, 1 );
    addPage( _pageVectors, QString("") );

    _pageFilters = new QWidget( this, "_pageFilters" );
    _pageFiltersLayout = new QGridLayout( _pageFilters, 1, 1, 11, 6, "_pageFiltersLayout"); 

    layout4 = new QGridLayout( 0, 1, 1, 0, 6, "layout4"); 

    _newFilter = new QPushButton( _pageFilters, "_newFilter" );

    layout4->addWidget( _newFilter, 1, 1 );
    spacer6 = new QSpacerItem( 121, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4->addItem( spacer6, 1, 0 );

    _filterList = new QListBox( _pageFilters, "_filterList" );

    layout4->addMultiCellWidget( _filterList, 0, 0, 0, 1 );

    _pageFiltersLayout->addMultiCellLayout( layout4, 0, 1, 1, 1 );

    textLabel4 = new QLabel( _pageFilters, "textLabel4" );

    _pageFiltersLayout->addWidget( textLabel4, 0, 0 );
    spacer7 = new QSpacerItem( 51, 151, QSizePolicy::Minimum, QSizePolicy::Expanding );
    _pageFiltersLayout->addItem( spacer7, 1, 0 );
    addPage( _pageFilters, QString("") );

    _pagePlot = new QWidget( this, "_pagePlot" );
    _pagePlotLayout = new QGridLayout( _pagePlot, 1, 1, 11, 6, "_pagePlotLayout"); 

    _windowGroup = new QButtonGroup( _pagePlot, "_windowGroup" );
    _windowGroup->setEnabled( TRUE );
    _windowGroup->setColumnLayout(0, Qt::Vertical );
    _windowGroup->layout()->setSpacing( 6 );
    _windowGroup->layout()->setMargin( 11 );
    _windowGroupLayout = new QVBoxLayout( _windowGroup->layout() );
    _windowGroupLayout->setAlignment( Qt::AlignTop );

    _currentWindow = new QRadioButton( _windowGroup, "_currentWindow" );
    _currentWindow->setChecked( TRUE );
    _windowGroupLayout->addWidget( _currentWindow );

    layout11 = new QHBoxLayout( 0, 0, 6, "layout11"); 

    _existingWindow = new QRadioButton( _windowGroup, "_existingWindow" );
    layout11->addWidget( _existingWindow );

    _windowName = new KstComboBox( _windowGroup, "_windowName" );
    _windowName->setEnabled( FALSE );
    _windowName->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, 1, 0, _windowName->sizePolicy().hasHeightForWidth() ) );
    layout11->addWidget( _windowName );
    _windowGroupLayout->addLayout( layout11 );

    _newWindow = new QRadioButton( _windowGroup, "_newWindow" );
    _windowGroupLayout->addWidget( _newWindow );

    _newWindows = new QRadioButton( _windowGroup, "_newWindows" );
    _newWindows->setEnabled( FALSE );
    _windowGroupLayout->addWidget( _newWindows );

    layout13 = new QHBoxLayout( 0, 0, 6, "layout13"); 

    _newWindowNameLabel = new QLabel( _windowGroup, "_newWindowNameLabel" );
    _newWindowNameLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)5, 0, 0, _newWindowNameLabel->sizePolicy().hasHeightForWidth() ) );
    layout13->addWidget( _newWindowNameLabel );

    _newWindowName = new QLineEdit( _windowGroup, "_newWindowName" );
    _newWindowName->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, 0, 0, _newWindowName->sizePolicy().hasHeightForWidth() ) );
    layout13->addWidget( _newWindowName );
    _windowGroupLayout->addLayout( layout13 );

    _pagePlotLayout->addMultiCellWidget( _windowGroup, 2, 3, 1, 1 );

    _plotGroup = new QButtonGroup( _pagePlot, "_plotGroup" );
    _plotGroup->setColumnLayout(0, Qt::Vertical );
    _plotGroup->layout()->setSpacing( 6 );
    _plotGroup->layout()->setMargin( 11 );
    _plotGroupLayout = new QGridLayout( _plotGroup->layout() );
    _plotGroupLayout->setAlignment( Qt::AlignTop );

    _onePlot = new QRadioButton( _plotGroup, "_onePlot" );
    _onePlot->setChecked( TRUE );

    _plotGroupLayout->addWidget( _onePlot, 0, 0 );

    _multiplePlots = new QRadioButton( _plotGroup, "_multiplePlots" );

    _plotGroupLayout->addWidget( _multiplePlots, 1, 0 );

    layout5 = new QHBoxLayout( 0, 0, 6, "layout5"); 

    _cycleThrough = new QRadioButton( _plotGroup, "_cycleThrough" );
    layout5->addWidget( _cycleThrough );

    _plotNumber = new QSpinBox( _plotGroup, "_plotNumber" );
    _plotNumber->setEnabled( FALSE );
    _plotNumber->setButtonSymbols( QSpinBox::PlusMinus );
    _plotNumber->setMaxValue( 20 );
    _plotNumber->setMinValue( 2 );
    layout5->addWidget( _plotNumber );

    _plotGroupLayout->addLayout( layout5, 2, 0 );

    _cycleExisting = new QRadioButton( _plotGroup, "_cycleExisting" );
    _cycleExisting->setChecked( FALSE );

    _plotGroupLayout->addWidget( _cycleExisting, 3, 0 );

    layout5_2 = new QHBoxLayout( 0, 0, 6, "layout5_2"); 

    _existingPlot = new QRadioButton( _plotGroup, "_existingPlot" );
    layout5_2->addWidget( _existingPlot );

    _existingPlotName = new KstComboBox( _plotGroup, "_existingPlotName" );
    _existingPlotName->setEnabled( FALSE );
    layout5_2->addWidget( _existingPlotName );

    _plotGroupLayout->addLayout( layout5_2, 4, 0 );

    _pagePlotLayout->addMultiCellWidget( _plotGroup, 0, 1, 1, 1 );

    buttonGroup1 = new QButtonGroup( _pagePlot, "buttonGroup1" );
    buttonGroup1->setMargin( 0 );
    buttonGroup1->setColumnLayout(0, Qt::Vertical );
    buttonGroup1->layout()->setSpacing( 6 );
    buttonGroup1->layout()->setMargin( 11 );
    buttonGroup1Layout = new QGridLayout( buttonGroup1->layout() );
    buttonGroup1Layout->setAlignment( Qt::AlignTop );

    _drawLines = new QRadioButton( buttonGroup1, "_drawLines" );
    _drawLines->setChecked( TRUE );

    buttonGroup1Layout->addWidget( _drawLines, 0, 0 );

    _drawBoth = new QRadioButton( buttonGroup1, "_drawBoth" );

    buttonGroup1Layout->addWidget( _drawBoth, 2, 0 );

    _drawPoints = new QRadioButton( buttonGroup1, "_drawPoints" );

    buttonGroup1Layout->addWidget( _drawPoints, 1, 0 );

    _pagePlotLayout->addWidget( buttonGroup1, 0, 0 );

    buttonGroup3 = new QButtonGroup( _pagePlot, "buttonGroup3" );
    buttonGroup3->setColumnLayout(0, Qt::Vertical );
    buttonGroup3->layout()->setSpacing( 6 );
    buttonGroup3->layout()->setMargin( 11 );
    buttonGroup3Layout = new QVBoxLayout( buttonGroup3->layout() );
    buttonGroup3Layout->setAlignment( Qt::AlignTop );

    _xAxisLabels = new QCheckBox( buttonGroup3, "_xAxisLabels" );
    _xAxisLabels->setChecked( TRUE );
    buttonGroup3Layout->addWidget( _xAxisLabels );

    _yAxisLabels = new QCheckBox( buttonGroup3, "_yAxisLabels" );
    _yAxisLabels->setChecked( TRUE );
    buttonGroup3Layout->addWidget( _yAxisLabels );

    _plotTitles = new QCheckBox( buttonGroup3, "_plotTitles" );
    _plotTitles->setChecked( TRUE );
    buttonGroup3Layout->addWidget( _plotTitles );

    layout20 = new QHBoxLayout( 0, 0, 6, "layout20"); 

    textLabel2_3 = new QLabel( buttonGroup3, "textLabel2_3" );
    textLabel2_3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)5, 0, 0, textLabel2_3->sizePolicy().hasHeightForWidth() ) );
    layout20->addWidget( textLabel2_3 );

    buttonGroup7 = new QButtonGroup( buttonGroup3, "buttonGroup7" );
    buttonGroup7->setFrameShape( QButtonGroup::NoFrame );
    buttonGroup7->setColumnLayout(0, Qt::Vertical );
    buttonGroup7->layout()->setSpacing( 0 );
    buttonGroup7->layout()->setMargin( 0 );
    buttonGroup7Layout = new QHBoxLayout( buttonGroup7->layout() );
    buttonGroup7Layout->setAlignment( Qt::AlignTop );

    _legendsOn = new QRadioButton( buttonGroup7, "_legendsOn" );
    buttonGroup7Layout->addWidget( _legendsOn );

    _legendsOff = new QRadioButton( buttonGroup7, "_legendsOff" );
    buttonGroup7Layout->addWidget( _legendsOff );

    _legendsAuto = new QRadioButton( buttonGroup7, "_legendsAuto" );
    _legendsAuto->setChecked( TRUE );
    buttonGroup7Layout->addWidget( _legendsAuto );
    layout20->addWidget( buttonGroup7 );
    buttonGroup3Layout->addLayout( layout20 );

    _pagePlotLayout->addMultiCellWidget( buttonGroup3, 1, 2, 0, 0 );

    _psdAxisGroup = new QButtonGroup( _pagePlot, "_psdAxisGroup" );
    _psdAxisGroup->setColumnLayout(0, Qt::Vertical );
    _psdAxisGroup->layout()->setSpacing( 6 );
    _psdAxisGroup->layout()->setMargin( 11 );
    _psdAxisGroupLayout = new QVBoxLayout( _psdAxisGroup->layout() );
    _psdAxisGroupLayout->setAlignment( Qt::AlignTop );

    _psdLogX = new QCheckBox( _psdAxisGroup, "_psdLogX" );
    _psdAxisGroupLayout->addWidget( _psdLogX );

    _psdLogY = new QCheckBox( _psdAxisGroup, "_psdLogY" );
    _psdAxisGroupLayout->addWidget( _psdLogY );

    _pagePlotLayout->addWidget( _psdAxisGroup, 3, 0 );

    layout26 = new QHBoxLayout( 0, 0, 6, "layout26"); 

    _reGrid = new QCheckBox( _pagePlot, "_reGrid" );
    layout26->addWidget( _reGrid );

    _columnLabel = new QLabel( _pagePlot, "_columnLabel" );
    _columnLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, _columnLabel->sizePolicy().hasHeightForWidth() ) );
    _columnLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    layout26->addWidget( _columnLabel );

    _plotColumns = new QSpinBox( _pagePlot, "_plotColumns" );
    _plotColumns->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, 0, 0, _plotColumns->sizePolicy().hasHeightForWidth() ) );
    _plotColumns->setMaxValue( 10 );
    _plotColumns->setMinValue( 1 );
    layout26->addWidget( _plotColumns );
    spacer31 = new QSpacerItem( 100, 31, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout26->addItem( spacer31 );

    _pagePlotLayout->addMultiCellLayout( layout26, 4, 4, 0, 1 );
    addPage( _pagePlot, QString("") );
    languageChange();
    resize( QSize(711, 456).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( _cycleThrough, SIGNAL( toggled(bool) ), _plotNumber, SLOT( setEnabled(bool) ) );
    connect( _existingPlot, SIGNAL( toggled(bool) ), _existingPlotName, SLOT( setEnabled(bool) ) );
    connect( _existingWindow, SIGNAL( toggled(bool) ), _windowName, SLOT( setEnabled(bool) ) );
    connect( _newWindow, SIGNAL( toggled(bool) ), this, SLOT( updatePlotBox() ) );
    connect( _currentWindow, SIGNAL( toggled(bool) ), this, SLOT( updatePlotBox() ) );
    connect( _existingWindow, SIGNAL( toggled(bool) ), this, SLOT( updatePlotBox() ) );
    connect( _windowName, SIGNAL( activated(int) ), this, SLOT( updatePlotBox() ) );
    connect( _applyFilters, SIGNAL( toggled(bool) ), this, SLOT( applyFiltersChecked(bool) ) );
    connect( _uncheckAll, SIGNAL( clicked() ), this, SLOT( uncheckAll() ) );
    connect( _checkVectors, SIGNAL( clicked() ), this, SLOT( fieldListChanged() ) );
    connect( _vectorReduction, SIGNAL( textChanged(const QString&) ), this, SLOT( vectorSubset(const QString&) ) );
    connect( _checkVectors, SIGNAL( clicked() ), this, SLOT( checkSelected() ) );
    connect( _newFilter, SIGNAL( clicked() ), this, SLOT( newFilter() ) );
    connect( _radioButtonPlotData, SIGNAL( clicked() ), this, SLOT( disablePSDEntries() ) );
    connect( _radioButtonPlotData, SIGNAL( clicked() ), this, SLOT( enableXEntries() ) );
    connect( _radioButtonPlotPSD, SIGNAL( clicked() ), this, SLOT( enablePSDEntries() ) );
    connect( _radioButtonPlotPSD, SIGNAL( clicked() ), this, SLOT( disableXEntries() ) );
    connect( _radioButtonPlotDataPSD, SIGNAL( clicked() ), this, SLOT( enablePSDEntries() ) );
    connect( _radioButtonPlotDataPSD, SIGNAL( clicked() ), this, SLOT( enableXEntries() ) );
    connect( _vectorSearch, SIGNAL( clicked() ), this, SLOT( _search() ) );
    connect( _newWindows, SIGNAL( toggled(bool) ), this, SLOT( updatePlotBox() ) );
    connect( _plotGroup, SIGNAL( clicked(int) ), this, SLOT( updateColumns() ) );
    connect( _windowGroup, SIGNAL( clicked(int) ), this, SLOT( updateColumns() ) );
    connect( _vectors, SIGNAL( pressed(QListViewItem*) ), this, SLOT( fieldListChanged() ) );
    connect( _url, SIGNAL( textChanged(const QString&) ), this, SLOT( sourceChanged(const QString&) ) );
    connect( _configureSource, SIGNAL( clicked() ), this, SLOT( configureSource() ) );
    connect( _testURL, SIGNAL( clicked() ), this, SLOT( testURL() ) );
    connect( _plotColumns, SIGNAL( valueChanged(int) ), this, SLOT( plotColsChanged() ) );

    // tab order
    setTabOrder( _url, _testURL );
    setTabOrder( _testURL, _configureSource );
    setTabOrder( _configureSource, _vectorReduction );
    setTabOrder( _vectorReduction, _vectorSearch );
    setTabOrder( _vectorSearch, _checkVectors );
    setTabOrder( _checkVectors, _uncheckAll );
    setTabOrder( _uncheckAll, _vectors );
    setTabOrder( _vectors, _kstDataRange );
    setTabOrder( _kstDataRange, _radioButtonPlotData );
    setTabOrder( _radioButtonPlotData, _radioButtonPlotPSD );
    setTabOrder( _radioButtonPlotPSD, _radioButtonPlotDataPSD );
    setTabOrder( _radioButtonPlotDataPSD, _xVector );
    setTabOrder( _xVector, _kstFFTOptions );
    setTabOrder( _kstFFTOptions, _applyFilters );
    setTabOrder( _applyFilters, _newFilter );
    setTabOrder( _newFilter, _filterList );
    setTabOrder( _filterList, _drawLines );
    setTabOrder( _drawLines, _drawPoints );
    setTabOrder( _drawPoints, _drawBoth );
    setTabOrder( _drawBoth, _xAxisLabels );
    setTabOrder( _xAxisLabels, _yAxisLabels );
    setTabOrder( _yAxisLabels, _plotTitles );
    setTabOrder( _plotTitles, _legendsOn );
    setTabOrder( _legendsOn, _legendsOff );
    setTabOrder( _legendsOff, _legendsAuto );
    setTabOrder( _legendsAuto, _psdLogX );
    setTabOrder( _psdLogX, _psdLogY );
    setTabOrder( _psdLogY, _onePlot );
    setTabOrder( _onePlot, _multiplePlots );
    setTabOrder( _multiplePlots, _cycleThrough );
    setTabOrder( _cycleThrough, _plotNumber );
    setTabOrder( _plotNumber, _cycleExisting );
    setTabOrder( _cycleExisting, _existingPlot );
    setTabOrder( _existingPlot, _existingPlotName );
    setTabOrder( _existingPlotName, _currentWindow );
    setTabOrder( _currentWindow, _existingWindow );
    setTabOrder( _existingWindow, _windowName );
    setTabOrder( _windowName, _newWindow );
    setTabOrder( _newWindow, _newWindows );
    setTabOrder( _newWindows, _newWindowName );
    setTabOrder( _newWindowName, _reGrid );
    setTabOrder( _reGrid, _plotColumns );

    // buddies
    _xvectLabel->setBuddy( _xVector );
    init();
}

/*
 *  Destroys the object and frees any allocated resources
 */
DataWizard::~DataWizard()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void DataWizard::languageChange()
{
    setCaption( tr2i18n( "Data Wizard" ) );
    textLabel2->setText( tr2i18n( "<p>Please select a <i>data source</i> to work from.  This will typically be your file containing data points or vectors.</p>" ) );
    _testURL->setText( tr2i18n( "Connec&t" ) );
    _configureSource->setText( tr2i18n( "Con&figure..." ) );
    setTitle( _pageDataSource, tr2i18n( "Data Source" ) );
    QToolTip::add( _vectorReduction, tr2i18n( "Search Filter" ) );
    QWhatsThis::add( _vectorReduction, tr2i18n( "Search Filter: Fields matching this filter will be selected and moved to the top of the list (but not checked).  '*' and '?' wild cards are supported." ) );
    _vectorSearch->setText( tr2i18n( "&Search" ) );
    QWhatsThis::add( _vectorSearch, tr2i18n( "Appends the '*' wild card to the beginning and end of the search filter to match everything containing the search filter text." ) );
    _checkVectors->setText( tr2i18n( "C&heck Selected" ) );
    QWhatsThis::add( _checkVectors, tr2i18n( "Mark all selected fields for making curves." ) );
    _uncheckAll->setText( tr2i18n( "&Uncheck All" ) );
    QWhatsThis::add( _uncheckAll, tr2i18n( "Clear all checked fields - undoes all previous selections." ) );
    _vectors->header()->setLabel( 0, tr2i18n( "Field/Column" ) );
    QToolTip::add( _vectors, tr2i18n( "Field Selection: checked fields are plotted." ) );
    QWhatsThis::add( _vectors, tr2i18n( "Field Selection: All checked fields will be plotted. Fields which are selected but not checked will not be plotted: they need to be checked first." ) );
    buttonGroup5->setTitle( tr2i18n( "Plot Types" ) );
    _radioButtonPlotDataPSD->setText( tr2i18n( "XY &and power spectrum" ) );
    QWhatsThis::add( _radioButtonPlotDataPSD, tr2i18n( "Produce both XY plots and Power Spectra of the data selected to the left." ) );
    _radioButtonPlotData->setText( tr2i18n( "&XY" ) );
    QWhatsThis::add( _radioButtonPlotData, tr2i18n( "Make XY plots only.  The Y (independent) variables are selected to the left.  The X (dependent) variable is selected below." ) );
    _radioButtonPlotPSD->setText( tr2i18n( "&Power spectrum" ) );
    QWhatsThis::add( _radioButtonPlotPSD, tr2i18n( "Only produce power spectrum plots.  The PSDs of the data selected to the left are generated using the parameters below." ) );
    _xvectLabel->setText( tr2i18n( "X axis vector:" ) );
    QWhatsThis::add( _xVector, tr2i18n( "The field to be used as the X axis in XY curves." ) );
    _applyFilters->setText( tr2i18n( "Apply filters" ) );
    setTitle( _pageVectors, tr2i18n( "Select Data" ) );
    _newFilter->setText( tr2i18n( "&New Filter..." ) );
    textLabel4->setText( tr2i18n( "<p>If you wish, select a filter to apply to the fields that are read in.</p>" ) );
    setTitle( _pageFilters, tr2i18n( "Filters" ) );
    _windowGroup->setTitle( tr2i18n( "Plot Place&ment" ) );
    _currentWindow->setText( tr2i18n( "In current &window" ) );
    _existingWindow->setText( tr2i18n( "In existing window" ) );
    _existingWindow->setAccel( QKeySequence( QString::null ) );
    _newWindow->setText( tr2i18n( "In new win&dow" ) );
    _newWindows->setText( tr2i18n( "XY and PSD pl&ots in separate new windows" ) );
    _newWindowNameLabel->setText( tr2i18n( "New window name:" ) );
    _plotGroup->setTitle( tr2i18n( "Cu&rve Placement" ) );
    _onePlot->setText( tr2i18n( "&All curves in one plot" ) );
    _multiplePlots->setText( tr2i18n( "&1 new plot per curve" ) );
    _multiplePlots->setAccel( QKeySequence( tr2i18n( "Alt+1" ) ) );
    _cycleThrough->setText( tr2i18n( "Cycle t&hrough" ) );
    _plotNumber->setSuffix( tr2i18n( " plots" ) );
    _cycleExisting->setText( tr2i18n( "Cycle through exi&sting plots" ) );
    _existingPlot->setText( tr2i18n( "All curv&es in plot" ) );
    buttonGroup1->setTitle( tr2i18n( "Cur&ve Style" ) );
    _drawLines->setText( tr2i18n( "L&ines only" ) );
    _drawBoth->setText( tr2i18n( "Lines and points" ) );
    _drawBoth->setAccel( QKeySequence( QString::null ) );
    _drawPoints->setText( tr2i18n( "&Points only" ) );
    buttonGroup3->setTitle( tr2i18n( "Label &Generation" ) );
    _xAxisLabels->setText( tr2i18n( "&X-axis labels" ) );
    _yAxisLabels->setText( tr2i18n( "&Y-axis labels" ) );
    _plotTitles->setText( tr2i18n( "&Title labels" ) );
    textLabel2_3->setText( tr2i18n( "Legends:" ) );
    buttonGroup7->setTitle( QString::null );
    _legendsOn->setText( tr2i18n( "O&n" ) );
    _legendsOff->setText( tr2i18n( "&Off" ) );
    _legendsAuto->setText( tr2i18n( "A&uto" ) );
    _psdAxisGroup->setTitle( tr2i18n( "Power Spectrum Axis Mode" ) );
    _psdLogX->setText( tr2i18n( "Lo&g X axis" ) );
    _psdLogY->setText( tr2i18n( "&Log Y axis" ) );
    _reGrid->setText( tr2i18n( "Re-grid" ) );
    _columnLabel->setText( tr2i18n( "Columns:" ) );
    setTitle( _pagePlot, tr2i18n( "Plot Layout" ) );
}

#include "datawizard.moc"
