/***************************************************************************
                   kstviewwidget.h: widget for the toplevel view
                             -------------------
    begin                : Mar 27, 2004
    copyright            : (C) 2003 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTVIEWWIDGET_H
#define KSTVIEWWIDGET_H

#include <qwidget.h>
#include "ksttoplevelview.h"

class QDragObject;
class KPopupMenu;

class KstViewWidget : public QWidget {
  Q_OBJECT
  public:
    KstViewWidget(KstTopLevelViewPtr view, QWidget *parent = 0L, const char *name = 0L, WFlags w = 0);
    virtual ~KstViewWidget();

    void setDropEnabled(bool);
    void setDragEnabled(bool);

    QDragObject *dragObject();
    KstTopLevelViewPtr viewObject() const;

    void paint();

    void nextUpdateDo(KstPaintType updateType);

    KstViewObjectPtr findChildFor(const QPoint& pos);

  protected:
    virtual void enterEvent(QEvent *e);
    virtual void leaveEvent(QEvent *e);
    virtual void mouseMoveEvent(QMouseEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseDoubleClickEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void contextMenuEvent(QContextMenuEvent *e);
    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);
    virtual void dragEnterEvent(QDragEnterEvent *e);
    virtual void dragMoveEvent(QDragMoveEvent *e);
    virtual void dragLeaveEvent(QDragLeaveEvent *e);
    virtual void dropEvent(QDropEvent *e);
    virtual void keyPressEvent(QKeyEvent *e);
    virtual void keyReleaseEvent(QKeyEvent *e);
    virtual void wheelEvent(QWheelEvent *e);

    friend class KstTopLevelView;
    void release() { _view = 0L; }

  private:
    KstTopLevelViewPtr _view;
    KstViewObject *_vo_datamode;
    bool _dropEnabled : 1;
    bool _dragEnabled : 1;
    KPopupMenu *_menu;
    QDragObject *_drag;
    KstPaintType _nextUpdate;
};

#endif
// vim: ts=2 sw=2 et
