/***************************************************************************
                          csubtitles.h  -  description
                             -------------------
    begin                : di feb 4 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSUBTITLES_H
#define CSUBTITLES_H

#include <csubtitle.h>
#include <qdatetime.h>
#include <qptrlist.h>
#include <qtextcodec.h>
#include <qtextstream.h>

/**Contains a number of subtitles
  *@author Tom Deblauwe
  */

class CSubtitles : public QPtrList<CSubtitle> {

  private:

  protected:
    //for sorting
    virtual int compareItems(QCollection::Item item1, QCollection::Item item2);

  public:
	  CSubtitles();
	  ~CSubtitles();

    enum SubFormat
    {
      subFormatSRT,
      subFormatSUB
    };
    typedef enum SubFormat SubFormat;

    CSubtitle* getSubtitle(long curPos) const;
    CSubtitle* getSubtitle(QTime curPos) const;
    int getNrOfSubtitles(void) const;
    long getTotalOccupiedTime(void);
    CSubtitle* getFirstSubtitle(void);
    CSubtitle* getLastSubtitle(void);
    QPtrListIterator<CSubtitle> getIterator(void) const;

    // to get start and endtimes after and before a sub respectively

    long getEndTimeBefore(CSubtitle * currentSub) const;
    long getStartTimeAfter(CSubtitle * currentSub) const;

    //used to write the subs to a file
    void subDump(QTextStream & stream, SubFormat format) const;

    bool stretchTime(long newTime, CSubtitle * sub);

    bool addSubtitle(CSubtitle *newSubtitle);
    bool addSubtitleWithWrongTiming(CSubtitle *newSubtitle);

    bool insertSubtitles( CSubtitles*  newSubs, long insertTime);
    bool removeSubtitle(CSubtitle *removeSub);

    void moveSubtitles( long newStartTime, CSubtitle * firstSub, CSubtitle * lastSub );
    static long getMSecs( QTime timeObject );
    static QTime getQTimeFromMSecs(long msecs);


    //for debugging
    void dumpSubs(void);

};

#endif
