#include "glwindow.h"
#include "sudoku_solver.h"
#include <qcursor.h>
#include "ksudoku.h"
#include <kmessagebox.h>
GLUquadricObj *quadratic;											// Used For Our Quadric

const float PI2 = 2.0*3.1415926535f;								// PI Squared



GLfloat LightAmbient[]= { 0.5f, 0.5f, 0.5f, 1.0f };
GLfloat LightDiffuse[]= { 0.8f, 1.0f, 1.0f, 1.0f };	
GLfloat LightPosition[]= { 0.0f, 0.0f, -10.0f, 5.0f };		

Matrix4fT Transform   = {  1.0f,  0.0f,  0.0f,  0.0f,				// NEW: Final Transform
                             0.0f,  1.0f,  0.0f,  0.0f,
                             0.0f,  0.0f,  1.0f,  0.0f,
                             0.0f,  0.0f,  0.0f,  1.0f };

Matrix3fT LastRot     = {  1.0f,  0.0f,  0.0f,					// NEW: Last Rotation
                             0.0f,  1.0f,  0.0f,
                             0.0f,  0.0f,  1.0f };

Matrix3fT ThisRot     = {  1.0f,  0.0f,  0.0f,					// NEW: This Rotation
                             0.0f,  1.0f,  0.0f,
                             0.0f,  0.0f,  1.0f };


glWindow::glWindow(QWidget *parent, const char *name, int orderp, int difficulty, int simmetry, bool dub)
 : QGLWidget(parent, name)
{
	wheelmove = 0.0f;
	dist = 5.3f;
	selected_number = -1;
	order = orderp;
	base = (int) sqrt(order);
	size = base*order;
	std::srand( time(0) );

	if(order == 9) mySolver = solver3d09;
	else if(order == 16) mySolver = solver3d16;
	else if(order == 25 ) mySolver = solver3d25;
	puzzle           = new skPuzzle(order, true);	
	completed_puzzle = new skPuzzle(order, true);

	guidedMode = false;

	isClicked  = false;
	isRClicked = false;	
	isDragging = false;	

	ITERATE(i,size)ITERATE(j,4)selected[i][j]=0;
	ITERATE(i,size)puzzle->numbers[i]=flags[i]=0;

	selection = -1;
	stack_d = 0;
	
	//genPuzzle();
	if(dub == 0)
	{
		mySolver->solve(puzzle, 1, puzzle);
		mySolver->copy(completed_puzzle, puzzle);
		/*remaining = */ mySolver->remove_numbers(puzzle,difficulty, simmetry, 1);
		ITERATE(i, puzzle->size) { puzzle->numbers[i] = puzzle->numbers[i]; flags[i] = puzzle->numbers[i] != 0;}
		push();
	}
	else
		ITERATE(i, puzzle->size) puzzle->numbers[i] = 0;
	
	((ksudoku*) parent) -> t.start();

}

int glWindow::genPuzzle(bool dub)
{
		ITERATE(i,puzzle->size)if(puzzle->numbers[i] != 0)
			ITERATE(j,mySolver->g->optimized_d[i]) if(puzzle->numbers[mySolver->g->optimized[i][j]] != 0) 
				if(i!=mySolver->g->optimized[i][j]) if(puzzle->numbers[i] == puzzle->numbers[mySolver->g->optimized[i][j]])
				{
					KMessageBox::information(this, ("The puzzle you entered contains some errors."));
					return -1;
				}

		int forks =0;
		if(mySolver->solve(puzzle, 1, completed_puzzle, &forks) == 1)
		{
			QString s = "";
			s.sprintf("One solution has been found (if you want to see it click on 'Solve' button)\nDIFFICULTY: I did %d guesses (forks) solving the puzzle.\nSearch for other solutions?", forks);
			if(KMessageBox::questionYesNo(this, s) != 4)
			{
				if(mySolver->solve(puzzle, 2, 0) > 1)
					KMessageBox::information(this, ("The puzzle you entered has multiple solutions."));
				else
					KMessageBox::information(this, ("The puzzle you entered has only one solution."));
			}
		}
		else
		{
			KMessageBox::questionYesNo(this, ("Sorry, No solutions have been found."));
			return -1;
		}

	ITERATE(i, puzzle->size) { puzzle->numbers[i] = puzzle->numbers[i]; flags[i] = puzzle->numbers[i] != 0;}

	return 0;
	
}

	void glWindow::giveHint()
	{
		
		int remaining = 0;
		ITERATE(i,size) if(puzzle->numbers[i] == 0) remaining++;
		if(remaining <= 0) return;
		//printf("%d\n", remaining);
		
		int i;
		do
			i = RANDOM(puzzle->size) ;		
		while(puzzle->numbers[i] != 0);
			
		puzzle->numbers[i] = completed_puzzle->numbers[i] ;
		flags [i] = 1;
		paintGL();
		if(isDragging) releaseMouse();
		((ksudoku*)parent())->checkCompleted();
	}

void glWindow::initializeGL()
{
	glClearColor( 0.0, 0.0, 0.0, 0.5 );
	glEnable(GL_TEXTURE_2D);						// Enable Texture Mapping ( NEW )
	//glShadeModel(GL_SMOOTH);						// Enable Smooth Shading
	//glClearColor(0.0f, 0.0f, 0.0f, 0.5f);					// Black Background
	//glClearDepth(1.0f);							// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);						// Enables Depth Testing
	//glDepthFunc(GL_LEQUAL);							// The Type Of Depth Testing To Do
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	

	setMouseTracking(true);
	
	QPixmap* pixs; 
	for(int o=0; o<2; o++) 
		for(int i=0; i<=9+o*16; i++)
		{
			int sz = 32;
			pixs = new QPixmap(sz,sz);

			QPainter p(pixs);
			QFont f;
			f.setPointSizeFloat((sz * 80) / 128);
			p.setFont(f);
			p.fillRect(rect(), QColor(255,255,255));
			if(i==0)
				p.drawText(0,0,sz,sz, Qt::AlignCenter, QString(QChar(' ')));
			else
			{
				QString s = QChar('0'*(o==0) + ('a'-1)*(o==1) +i);
				if(s == "9" || s == "6" || s == "b" || s == "d") s += '.';
				p.drawText(0,0,sz,sz, Qt::AlignCenter, s);
			}
			p.setPen(QPen(QColor(0,0,0), 2));
			p.drawRect ( 0, 0, sz, sz );	
			p.end();
			QImage pix = convertToGLFormat(pixs->convertToImage());
	
			glGenTextures(1, &texture[o][i]);
			glBindTexture(GL_TEXTURE_2D, texture[o][i]);
			glTexImage2D(GL_TEXTURE_2D, 0,4, sz,sz, 0, GL_RGBA, GL_UNSIGNED_BYTE, (GLvoid*) pix.bits());
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	// Linear Filtering
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);	// Linear Filtering
			delete pixs;
		}
	/*glEnable(GL_LIGHTING); //UNCOMMENT FOR LIGHTS
	glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);	
	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
	glEnable(GL_LIGHT1);	
	glEnable(GL_COLOR_MATERIAL);	*/
}

	void glWindow::mouseDoubleClickEvent ( QMouseEvent * e )
	{
		if(selection == -1) return;
		if(selected_number == -1) return;
 		if(flags[selection] == 1) return;
		puzzle->numbers[selection] = selected_number;
		paintGL();
		if(isDragging) releaseMouse();
		((ksudoku*)parent())->checkCompleted();
	}

void glWindow::Selection(int mouse_x, int mouse_y)
{
	if(isDragging) return;
	ITERATE(i,size)ITERATE(j,4) selected[i][j] = 0;
	GLuint	buffer[512];
	GLint	hits;

	GLint	viewport[4];

	glGetIntegerv(GL_VIEWPORT, viewport);
	glSelectBuffer(512, buffer);								
	(void) glRenderMode(GL_SELECT);

	glInitNames();
	glPushName(0);

	glMatrixMode(GL_PROJECTION);								// Selects The Projection Matrix
	glPushMatrix();												// Push The Projection Matrix
	glLoadIdentity();											// Resets The Matrix

	// This Creates A Matrix That Will Zoom Up To A Small Portion Of The Screen, Where The Mouse Is.
	gluPickMatrix((GLdouble) mouse_x, (GLdouble) (viewport[3]-mouse_y), 1.0f, 1.0f, viewport);
	gluPerspective(45.0f, (GLfloat) (viewport[2]-viewport[0])/(GLfloat) (viewport[3]-viewport[1]), 0.1f, 100.0f);
	glMatrixMode(GL_MODELVIEW);
	paintGL();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);	
	hits=glRenderMode(GL_RENDER);
								
	if (hits > 0)
	{
		int	choose = buffer[3];
		int depth = buffer[1];

		selected[choose][0] = 1;
		for (int loop = 1; loop < hits; loop++)	
		{
			// If This Object Is Closer To Us Than The One We Have Selected
			if (buffer[loop*4+1] < GLuint(depth))
			{
				choose = buffer[loop*4+3];
				depth = buffer[loop*4+1];
			}
		}

		if(choose <= size && choose > 0)
		{
			selection  = choose-1;
			selected[choose-1][0] = 1;
		}
		grabKeyboard();
		paintGL();
    }
	else {selection = -1; releaseKeyboard();}
}


void glWindow::mouseMoveEvent ( QMouseEvent * e )
{
	Point2fT f;
	f.T[0] = e->x();
	f.T[1] = e->y();
	
	Selection(e->x(), e->y());

	if (isRClicked)													// If Right Mouse Clicked, Reset All Rotations
    {
		Matrix3fSetIdentity(&LastRot);								// Reset Rotation
		Matrix3fSetIdentity(&ThisRot);								// Reset Rotation
        Matrix4fSetRotationFromMatrix3f(&Transform, &ThisRot);		// Reset Rotation
    }

    if (!isDragging)												// Not Dragging
    {
        if (isClicked)												// First Click
        {
			isDragging = true;										// Prepare For Dragging
			LastRot = ThisRot;										// Set Last Static Rotation To Last Dynamic One
			ArcBall->click(&f);								// Update Start Vector And Prepare For Dragging
			grabMouse(/*QCursor(Qt::SizeAllCursor)*/);
        }
		paintGL();
    }
    else
    {
        if (isClicked)												// Still Clicked, So Still Dragging
        {
            Quat4fT     ThisQuat;

            ArcBall->drag(&f, &ThisQuat);						// Update End Vector And Get Rotation As Quaternion
            Matrix3fSetRotationFromQuat4f(&ThisRot, &ThisQuat);		// Convert Quaternion Into Matrix3fT
            Matrix3fMulMatrix3f(&ThisRot, &LastRot);				// Accumulate Last Rotation Into This One
            Matrix4fSetRotationFromMatrix3f(&Transform, &ThisRot);	// Set Our Final Transform's Rotation From This One
        }
        else	
		{													// No Longer Dragging
            isDragging = false;
			releaseMouse ();
		}
		paintGL();

    }
}

void glWindow::keyReleaseEvent ( QKeyEvent * e ) 
{
	if(selection        == -1) return;
	if(flags[selection] ==  1) return; //it is given by puzzle so skip

	char c = e->ascii();
	if(c >= 'A' && c <= 'Z') c = c+32;
	int n = e->ascii()-puzzle->zerochar;
	if(n >= 0 && n <= (puzzle->order))
	{
		//if(puzzle->numbers[selection] == 0 && n!=0)	remaining--;
		//if(puzzle->numbers[selection] != 0 && n==0)remaining++;
		puzzle->numbers[selection] = n;
		if(isDragging) releaseMouse();
		((ksudoku*)parent())->checkCompleted();
		paintGL();
	}

		
}

void glWindow::push()
{
	if(isDragging) releaseMouse();
	
	if(stack_d > 255) return;
	if(puzzle == 0) return;

	ITERATE(i,puzzle->size)
	{
		stack[stack_d].numbers[i]  = puzzle->numbers[i];
	}	
	stack_d++;
}
void  glWindow::pop()
{
	if(isDragging) releaseMouse();

	if(puzzle == 0) return;
	if(stack_d == 0) {KMessageBox::information(this, "Error: The checkpoint stack is empty."); return;}	

	stack_d--;
	ITERATE(i,puzzle->size)
	{
		puzzle->numbers[i] = stack[stack_d].numbers[i];
	}
	if(stack_d == 0) stack_d = 1;
	paintGL();	
}


void glWindow::myDrawCube(int name, GLfloat x, GLfloat y, GLfloat z, int texturef)
{
	glPushMatrix();
	glLoadName(name+1);
	glTranslatef(x,y,z);

	glBindTexture(GL_TEXTURE_2D, texture[order >= 16][puzzle->numbers[name]]);

	float sz = 1.0f;
	float s = 0.1f;
	if(selection != -1 && selection != name)
		if(mySolver->g->graph[selection][name] == 1)
		{
			s = -0.25f;
			sz = 0.52f;
		}

	glColor3f(0.5f+s,0.5f+s,1.0f+s);	
	if(flags[name] == 1)
		if(s>0.0f) glColor3f(0.35f,0.70f,0.45f); else  {glColor3f(0.4f,0.4f,0.8f); sz+=0.15;};	//(0.7f,160.0f/255.0f,30.0f/255.0f);
	if(selection == name)
		glColor3f(0.75f,0.25f,0.25f);

	if(puzzle->numbers[name] != 0)
		if(puzzle->numbers[name] != completed_puzzle->numbers[name] && guidedMode)
			glColor3f(0.75f,0.25f,0.25f);

	 glBegin(GL_QUADS);
        /* front face */
        glTexCoord2f(0.0f, 0.0f);
        glVertex3f(-sz, -sz, sz); 
        glTexCoord2f(1.0f, 0.0f);
        glVertex3f(sz, -sz, sz);
        glTexCoord2f(1.0f, 1.0f);
        glVertex3f(sz, sz, sz);
        glTexCoord2f(0.0f, 1.0f);
        glVertex3f(-sz, sz, sz);
        /* back face */
        glTexCoord2f(1.0f, 0.0f);
        glVertex3f(-sz, -sz, -sz); 
        glTexCoord2f(1.0f, 1.0f);
        glVertex3f(-sz, sz, -sz);
        glTexCoord2f(0.0f, 1.0f);
        glVertex3f(sz, sz, -sz);
        glTexCoord2f(0.0f, 0.0f);
        glVertex3f(sz, -sz, -sz);
        /* right face */
        glTexCoord2f(1.0f, 0.0f);
        glVertex3f(sz, -sz, -sz); 
        glTexCoord2f(1.0f, 1.0f);
        glVertex3f(sz, sz, -sz);
        glTexCoord2f(0.0f, 1.0f);
        glVertex3f(sz, sz, sz);
        glTexCoord2f(0.0f, 0.0f);
        glVertex3f(sz, -sz, sz);
        /* left face */
        glTexCoord2f(1.0f, 0.0f);
        glVertex3f(-sz, -sz, sz); 
        glTexCoord2f(1.0f, 1.0f);
        glVertex3f(-sz, sz, sz);
        glTexCoord2f(0.0f, 1.0f);
        glVertex3f(-sz, sz, -sz);
        glTexCoord2f(0.0f, 0.0f);
        glVertex3f(-sz, -sz, -sz);
        /* top face */
        glTexCoord2f(1.0f, 0.0f);
        glVertex3f(sz, sz, sz); 
        glTexCoord2f(1.0f, 1.0f);
        glVertex3f(sz, sz, -sz);
        glTexCoord2f(0.0f, 1.0f);
        glVertex3f(-sz, sz, -sz);
        glTexCoord2f(0.0f, 0.0f);
        glVertex3f(-sz, sz, sz);
        /* bottom face */
        glTexCoord2f(1.0f, 0.0f);
        glVertex3f(sz, -sz, -sz); 
        glTexCoord2f(1.0f, 1.0f);
        glVertex3f(sz, -sz, sz);
        glTexCoord2f(0.0f, 1.0f);
        glVertex3f(-sz, -sz, sz);
        glTexCoord2f(0.0f, 0.0f);
        glVertex3f(-sz, -sz, -sz);
    glEnd();
	glPopMatrix();
}

void glWindow::paintGL()
{

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();

	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
	glTranslatef(0.0f, 0.0f, -dist*(base+3)+wheelmove);

    glMultMatrixf(Transform.M);

	int c=0;

	ITERATE(xx, base)
		ITERATE(yy,base)
			ITERATE(zz, base)
			{
				glPushMatrix();
				glTranslatef(-(dist*base-dist)/2,-(dist*base-dist)/2,-(dist*base-dist)/2);
				myDrawCube(c++,(GLfloat) (dist*xx), (GLfloat)(dist* yy ), (GLfloat) (dist*zz), 0);
				glPopMatrix();
			}
   

	swapBuffers();
}

glWindow::~glWindow()
{
	glDeleteTextures(10, texture[0]);
	glDeleteTextures(25, texture[1]);
}


#include "glwindow.moc"
