// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005

#include "ksudokuview.h"
#include "qsudokubutton.h"
#include <kmessagebox.h>

#include <ksudoku.h>

QSudokuButton::QSudokuButton(QWidget *parent, const char *name, int xx, int yy)
 : QWidget(parent, name)
{
	x = xx;
	value = 0;
	y = yy;	
	mousein  =false;
	
	justmarked = false;
	given = false;
	wrong = true;  //2FIX
	
	highlighted[0] = 0;
	highlighted[1] = 0;
	highlighted[2] = 0;
	
	text = " ";

	setFocusPolicy(QWidget::ClickFocus);
	
	p = (ksudokuView*) parent;
	/*connect(this, SIGNAL(setWindowCaption(const QString&)),
            this,   SLOT(slotSetTitle(const QString&)));*/
	
}

QSudokuButton::~QSudokuButton()
{
}

void QSudokuButton::resize()
{
	if(p->puzzle->order == 0) p->puzzle->order = 9;
	int w = p->width();
	int h =p->height();
	this->setGeometry(x*(w/p->puzzle->order) , y*(h/p->puzzle->order) ,(w/p->puzzle->order) ,(h/p->puzzle->order));
}

void QSudokuButton::enterEvent (QEvent *)
{
	emit enter(x,y);
	setFocus();
	mousein = true;
}

void QSudokuButton::leaveEvent (QEvent *) 
{
	emit leave(x,y);
	mousein = false;
}

void QSudokuButton::exitEvent (QEvent *) 
{
	mousein = false;
	emit enter(x,y);
}

void QSudokuButton::keyPressEvent ( QKeyEvent * e ) 
{
	if(e->stateAfter() & Qt::ShiftButton || e->state() & Qt::ShiftButton)
		emit beginHighlight(this->value);
}
	
void QSudokuButton::keyReleaseEvent ( QKeyEvent * e ) 
{
	if(e->stateAfter() & Qt::ShiftButton || e->state() & Qt::ShiftButton )
		emit finishHighlight();
	if(given) return; //it is given by puzzle so skip

	char c = e->ascii();
	if(c >= 'A' && c <= 'Z') c = c+32;
	int n = e->ascii()-p->puzzle->zerochar;
	if(n > 0 && n <= (p->puzzle->order))
	{
		if(p->isWaitingForNumber == -1)
		{
			if(e->state() & Qt::AltButton)
				justmark(n);
			else
				setValue(n);
					
		} 
		else if(p->isWaitingForNumber == x*p->puzzle->order+y)
		{
			justmark(n);
		}
	}
		
}

void QSudokuButton::justmark(int n)
{
	value = 0;
	justmarked = true;
	if(n != 0) {

	int i = text.find(n + p->puzzle->zerochar);
	if(i==-1)
	{
		QString b = "  ";
		b[0] = n + p->puzzle->zerochar;
		text.append(b);
	}
	else
		text.remove(i,2);
	paintEvent(0);
}
}

void QSudokuButton::setValue(int n)
{
	if(value!=n) 
	{	
		value = n;
		((ksudoku*)p->parent())->checkCompleted();
	}
	value = n;
	justmarked = false;
	//emit numberset(x,y,n);

	if(n == 0)
	{
		text = "";
		wrong = true;
	}
	else
	{
		text = " ";
		text[0] = n + p->puzzle->zerochar;
				
		if(p->completed_puzzle->numbers[x*p->completed_puzzle->order+y] == n)
			wrong = false;
		else
			wrong = true;
	}
		
	paintEvent(0);


}	

void QSudokuButton::paintEvent (QPaintEvent *)
{
	QPainter qpainter (this);
	QFont f;
	QPen pen( QColor(150,150,150) );
	QPen pen2 = QPen(QColor(0,0,0));

	qpainter.eraseRect(rect());
	if(p->highlighted == -1)
	{
		unsigned char cc[3][3] = {{0xf1,0x9e,0x53},{0x9b,0xcb,0xe8},{0xad,0xe8,0x9b}};
		unsigned int c[3]  = {0xdc,0xdc,0xdc};
		if(p->showTracker) 
		{
			ITERATE(i,3)
				if(highlighted[i] != 0) 
					ITERATE(j,3)
						c[j] = c[j]*.475f + cc[i][j]*.475f;
			if(highlighted[0]+highlighted[1]+highlighted[2] == 3)
				ITERATE(i,3)
					c[i] = 0xdc*.205f+cc[0][i]*.205f+cc[1][i]*.205f+cc[2][i]*.205f;
		}
		qpainter.fillRect(rect(), QBrush(QColor(c[0],c[1],c[2])));
	}
	else
		if(highlighted[3]==1 || given == true)
			qpainter.fillRect(rect(), QBrush(QColor(255,200,200)));


 	if(p->isWaitingForNumber == x*p->puzzle->order+y)
		qpainter.eraseRect(rect());

	pen2.setWidth(4);
	pen.setWidth(1);
	qpainter.setPen(pen );
	qpainter.drawRect (rect());
	qpainter.setPen(pen2);
	
	int puzzle_base = (int) sqrt(p->puzzle->order);
	if(x%puzzle_base == puzzle_base-1)
		qpainter.drawLine(rect(). width(), 0, rect(). width(), rect().height());
	if(y%puzzle_base == puzzle_base-1)
		qpainter.drawLine(0, (int)rect().height(), (int)rect().width(), (int)rect().height());
	
	
	if(given)qpainter.setPen(QColor(0,0,100));
	else 	 qpainter.setPen(QColor(125,125,125));
	

	if(justmarked)
	{
		qpainter.setPen(QColor(80,80,80)  );
		f.setPointSizeFloat(2.85*rect().height()/10 );
		//f.setWeight(QFont::DemiBold);
		qpainter.setFont(f);
    	qpainter.drawText( rect(), AlignRight, text);
	}
	else
	{
		if(guidedMode ==1 && wrong && p->puzzle_mark_wrong && !given) qpainter.setPen(darkRed);
		f.setPointSizeFloat(4.0*rect().height()/10 );
		//f.setWeight(QFont::Bold);
		qpainter.setFont(f);
    	qpainter.drawText( rect(), AlignCenter, text);
	}
}

void QSudokuButton::mousePressEvent (QMouseEvent *mouseevent)
{

	if(mouseevent->button() == Qt::LeftButton)
		emit clicked2 (x,y);
		
	if(mouseevent->button() == Qt::RightButton)
		emit rightclicked (x,y);
}


void QSudokuButton::animate()
{
	paintEvent(0);
}
