// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005
#include "sudoku_solver.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <kmessagebox.h>
//#include "sudoku_types.h"

// SUDOKU PUZZLE SOLVER BASIC ALGORITHM - BY FRANCESCO ROSSI 2005 redsh@email.it
skPuzzle stack[625+1];



skSolver::skSolver(int n, bool threedimensionalf)
{
	base = sqrt(n);
	order=n;
	threedimensional = threedimensionalf ;

	if(threedimensionalf)
		size = base*order;
	else
		size = n*n;
}

skSolver::~skSolver()
{
	delete g;
}

int get_simmetric(int order, int size, int type, int idx, int which, int out[4])
{
	out[0] = idx;
	switch (type)
		{
			case SIMMETRY_NONE:
				return 1;
			case SIMMETRY_DIAGONAL:
				if(which == 1)
					idx = (order-1-idx/order)*order+order-1-idx%order;
				out[1] = (idx%order)*order+idx/order;
				return 2-(out[1]==out[0]);
			case SIMMETRY_CENTRAL:
				out[1] =size-idx-1;
				return 2-(out[1]==out[0]);
			case SIMMETRY_FOURWAY:
				bool b[3] = {1,1,1};
				out[1]=out[2]=out[3]=0;
				if(order % 2 == 1)
				{
					if((idx % order) == (order-1)/2) b[0] = b[2]=0;
					if((idx / order) == (order-1)/2) b[1] = b[2]= 0;
				}

				int c=1;

				if(b[2]==0)
				{
					out[1] = (order-1-idx/order)*order+order-1-idx%order;
						if(out[1] != out[0]) c++;
				}
				else {
					out[1] = (order-1-idx/order)*order+order-1-idx%order;
					out[2] = (idx/order)*order+order-1-idx%order;
					out[3] = (order-1-idx/order)*order+idx%order;
					c =4;
				}
				
				/*printf("%d (%d %d) (%d %d) (%d %d) (%d %d)  - %d %d %d\n", c, idx%order, idx/order, 
																		out[1]%order, out[1]/order, 
																		out[2]%order, out[2]/order, out[3]%order, out[3]/order, b[0],  b[1], b[2]);*/
				return c;
		}
	return 1;
}


int skSolver::remove_numbers(skPuzzle* p, int level, int simmetry, int type)
{
	std::srand(time(0));
	int  b;
	int cnt=p->size;
	int to=p->size*(4+4*(level==-1));
	int solutions_d=0;
	//skPuzzle stack[257];
	bool done[625+1];
	ITERATE(i,p->size+1){ stack[i].setorder(order); done[i]=false;};
		
	if(p->order>9) to = (p->size-32)/2;
	//if(p->order>16) to = (p->size-32)/(2);
	skPuzzle c(p->order);
	copy(&c, p);
	
	if(level < 0 && p->order==9)
	{
		int val = RANDOM(p->order)+1;
		ITERATE(i,size)
			if(p->numbers[i] == val){ p->numbers[i] = 0;  p->numbers[p->size-i-1]=0; cnt-=2;}
	}

	if(simmetry == SIMMETRY_RANDOM) simmetry = RANDOM(3)+2;
	int which = RANDOM(2);
	if(type == 1) simmetry = SIMMETRY_CENTRAL;
	if(simmetry == SIMMETRY_FOURWAY && order == 16) to=to*1/2;
	if(order == 25) simmetry = SIMMETRY_NONE; // TOO SLOW

	ITERATE(q, to) 
	{
		int idx = RANDOM(p->size);  //2FIX
		printf("%d/%d\n", q,to);
		int index [4]; //{idx, };
		int index_d = get_simmetric(order, size,simmetry, idx, which, index);

		int backup[4] = {0,0,0,0};
		
		int n_err = 0;
		ITERATE(i, index_d)
		{
			backup[i] = p->numbers[index[i]];
			if(backup[i] != 0 && done[index[i]] == false) 
			{
				done[index[i]] = true;
				solutions_d=0;
				p->numbers[index[i]] = 0;
				copy(&stack[0], p);
				solve_engine(&stack[0], solutions_d, 0, 2, index[i], index[i], backup[i]);
				n_err += (solutions_d != 1);
			}
			else
				n_err=1;
		}
		if(n_err > 0)
			ITERATE(i, index_d)
				p->numbers[index[i]] = backup[i];
		else	
			cnt-=index_d;
	}
	printf("%d\n", cnt);

		
	ITERATE(i, level*(p->order+LEVINC-(p->order-2)*type))
	{
		int idx = RANDOM(p->size);//2FIX
		while(p->numbers[idx] != 0) idx=(idx+1) % p->size;
		p->numbers[idx] = c.numbers[idx];
		int index[4];
		int index_d = get_simmetric(order, size,simmetry, idx, which, index);
		ITERATE(j, index_d)
		{
			p->numbers[index[j]] = c.numbers[index[j]];
			i++;	
			cnt++;
		}
	}
	
	/* GENERATES PUZZLES WITH MULTIPLE SOLUTIONS
	if(level < 0)
	{
		ITERATE(i,2)
		{
			int idx = RANDOM(p->size);//2FIX
			while(p->numbers[idx] == 0) idx=(idx+1) % p->size;
			p->numbers[idx] = 0;
			cnt--;
		}
	}*/
	
	return cnt;
}

skPuzzle* head;

#define MAX_FORKS 15000
int skSolver:: solve(skPuzzle* puzzle, int max_solutions, skPuzzle* out_solutions, int* forks)
{
	if(puzzle->order != order) return -1;
	if(g == 0) return -2;
	int solutions_d=0;
	int ffs=0;

	if(puzzle->order == 25 && puzzle->threedimensional==0)
		forks = &ffs;
	
	head = &stack[0];
	ITERATE(i,puzzle->size+1) stack[i].setorder(order, puzzle->threedimensional);
	copy(&stack[0], puzzle);
	solve_engine(&stack[0], solutions_d, out_solutions, max_solutions, -1, -1, 0, forks);
	if(puzzle->order == 25 && puzzle->threedimensional==0 && ffs > MAX_FORKS)
	{
		ITERATE(i,puzzle->size) puzzle->numbers[i] = 0;
		solve(puzzle, 1, puzzle,0);
	}
	if(forks) printf("%d\n", *forks);
	
	return solutions_d;
}

int skSolver:: solve_engine(skPuzzle *s,  int& solutions, skPuzzle* solution_list, int maxsolutions, int last_add,	 int dynindex, int dynvalue, int* forks) //last_add for further optimizations
{
	if(forks && s->order == 25 && s->threedimensional==0)
	{	
		//printf("%d\n", *forks);
		if((*forks) > MAX_FORKS)
			return -1;
	}
	
	if(maxsolutions>0 && solutions>=maxsolutions)	return 0;
	
	if(dynindex!=-1)if(dynvalue == s->numbers[dynindex])
	{
		solutions++;
		return 1;
	}
	/*{//DEBUG 
		printf("%d Solution found TC\n", solutions);
		ITERATE(i,s->size)
		{
			printf("%c", zerochar  + s->numbers[i]);
			if(i%s->order == s->order-1) printf("\n");
		}
	}*/
	//int rr = 0;
	int lowest_pos,lowest,lowest_val;

	lowest = s->order+1;
		
	for(int i=last_add*(last_add != -1); i<(last_add+1)+s->size*(last_add == -1); i++)
		if(s->numbers[i] != 0)
			ITERATE(j,g->optimized_d[i])
				if(s->numbers[g->optimized[i][j]] == 0)
					s->flags[g->optimized[i][j]][s->numbers[i]] = 0;
		
	for(int q=0; (last_add==-1) ? q<s->size : q<g->optimized_d[last_add]; q++)
	{
		int i = (last_add==-1) ? q : g->optimized[last_add][q];
		if(s->numbers[i] == 0)
		{
			int c=0;
			ITERATE(j,s->order)
				c+=s->flags[i][j+1];
				
			/*if(c==lowest) //otherwise i got problems with order = 25
			{
				if(RANDOM(++rr) == 0);
				lowest--;
			}*/
			if(c<lowest)
			{
				lowest_pos = i;
				lowest     = c;

				if(lowest < 1)
					return -1;
				if(lowest == 1)
				{
					ITERATE(j,s->order) if(s->flags[lowest_pos][j+1] == 1) lowest_val = j+1;
					//ITERATE(j, s-head) printf(" "); printf("ADDED %d %d\n", lowest_pos, lowest_val);
					s->numbers[lowest_pos] = lowest_val;

					return solve_engine(s, solutions, solution_list, maxsolutions, lowest_pos,-1,0,forks);
				}
			}
		}
	}
	
	if(last_add != -1) return solve_engine(s, solutions, solution_list, maxsolutions, -1,-1,0,forks);
	//check completed
	int remaining=0;
	ITERATE(i,s->size)if(s->numbers[i] == 0)remaining++;

	if(remaining == 0)
	{
	
		if(solution_list) 
			if(&solution_list[solutions]) 
				copy(&solution_list[solutions], s);
		solutions++;
	
		/*{
			printf("%d Solution found TC\n", solutions);
			ITERATE(i,s->size)
			{
				printf("%c", zerochar  + s->numbers[i]);
				if(i%s->order == s->order-1) printf("\n");
			}
		}*/
		return 1;
	}
	
	if(remaining == 1) return -1;
	
	//fork on lowest if not added
	int positions[26]; //2fix
	int positions_d = 0;
		
	ITERATE(i, s->order)
		if(s->flags[lowest_pos][i+1])
			positions[positions_d++] = i+1;
			
	while(positions_d>0)
	{	
		copy(&s[1], s);
		int index = RANDOM(positions_d);
		s[1].numbers[lowest_pos] = positions[index];
		solve_engine(&s[1], solutions, solution_list, maxsolutions, lowest_pos, -1, 0, forks);

		if(forks) (*forks)++;
		for(int i=index; i<positions_d-1; i++) positions[i] = positions[i+1];
		positions_d--;
	}
	
	return -1;	
}


int skSolver:: init()
{
	g = new skGraph(order, threedimensional);
	
	if(!threedimensional)
	{
		int row,col, subsquare;
		
		ITERATE(i,g->size)
		{
			ITERATE(j,g->order) g->graph[i][j] = 0;
			row       = i / g->order;
			col       = i % g->order;
			subsquare = col/g->base+(row/g->base)*g->base;
			
			ITERATE(j,g->order)
			{
				g->graph[i][j+row*g->order]  = 1;
				g->graph[i][j*g->order+col]  = 1;
				g->graph[i][((subsquare/g->base)*g->base + j%g->base) * g->order + 
				(subsquare%g->base)*g->base + j/g->base] = 1;
			}
		}
	}
	else
	{
		int faces[3];
		ITERATE(i,g->size)
		{
			ITERATE(j,g->order) g->graph[i][j] = 0;
			faces[0] = i / order;
			faces[1] = i % base;
			faces[2] = (i % order) / base;
			
			ITERATE(j,g->size) //2FIX : SLOW
			{
				if(j / order == faces[0]) g->graph[i][j]  = 1;
				if(j % base == faces[1]) g->graph[i][j]  = 1;
				if((j % order) / base == faces[2]) g->graph[i][j]  = 1;
			}
		}
	}

	ITERATE(i,g->size)
	{
		g->optimized_d [i] = 0;
		ITERATE(j,size)
			if(g->graph[i][j]==1)
			{
				g->optimized[i][g->optimized_d [i]]=(int) j;
				g->optimized_d [i]++;
			}
	}

	if(order>9) zerochar = 'a'-1;
	else zerochar = '0';
	
	//findStronglyConnectedComponents
	/*printf("Now fscc!\n");
	bool done[625+1];
	bool visited[625+1];

		ITERATE(i,125) ITERATE(j,size) g->strongly_connected[i][j] = 0;	

	g->sc_count=0;
	ITERATE(i,size)
	{
		ITERATE(j,size) visited[j]=0;
		fscc(visited, done, g->graph[i], i);
		done[i]=1;
	}
	printf("%d\n",g->sc_count);
	int* optimized_sc_d = new int[g->sc_count];
	int** optimized_sc   = new (int*)[g->sc_count];
	
	
	ITERATE(i, g->sc_count)
	{
		optimized_sc_d[i] = 0;
		ITERATE(j,size)
			if(g->strongly_connected[i][j] == 1)
				optimized_sc_d[i]++;
		optimized_sc[i] = new int[optimized_sc_d[i]];
		int c=0;
		ITERATE(j,size)
		{
			if(g->strongly_connected[i][j] == 1)
				{optimized_sc[i][c++] = j;
				printf("%d", 1);
				}else printf("%d",0);

		}
			printf("\n");
		
	}*/
		
}

	//findStronglyConnectedComponents
int skSolver::fscc(bool* visited, bool* done, bool mask[625], int node)
{
	/*if(done[node]==1) return 0;
	int cc=0;
	ITERATE(i, size) if(mask[i] == 1) cc++;
	if(cc == 0) return  0;	

	visited[node] = 1;

	int c=0;	
	bool* m = new bool[size];	//2FIX
	//bool m[256];
	
	ITERATE(i,size)
		if(mask[i] == 1 && visited[i] == false)
		{
			c=1;
			if(done[i] == false)
			{
				ITERATE(j,size) m[j] = mask[j] & g->graph[i][j];
				c+=fscc(visited, done, m, i);	
			}
		}	
	if(c==0)
	{
		ITERATE(i, size){ g->strongly_connected[g->sc_count][i] = mask[i];}
		/*ITERATE(i, g->sc_count)
			ITERATE(j, size)
				if(g->strongly_connected[i][j] != g->strongly_connected[g->sc_count][j])
				{
					g->sc_count++;
					visited[node] = 0;
					return 1;
				//}
		return 1;
	}
	//visited[node] = 0;
	return 0;*/
}

void skSolver::copy(skPuzzle* dest, skPuzzle* src)
{
	dest->order = src->order;
	dest->base  = src->base;
	dest->size  = src->size;

	ITERATE(i, src->size)
	{
		dest->numbers[i] = src->numbers[i];
		ITERATE(j, src->order+1)
			dest->flags[i][j] = 1;//src->flags[i][j];
	}
	
}
