/*
Part of KSudoku project
http://ksudoku.sf.net
(c) 2005 Francesco Rossi <redsh@email.it>
(c) 2007 Johannes Bergmeier <Johannes.Bergmeier@gmx.net>
	 Mick Kappenburg <ksudoku@kappenburg.net>
	 Francesco Rossi <redsh@email.it>

This is free software released under GNU GENERAL PUBLIC LICENSE (GPLv2)
See COPYING file in project root directory for more information.

See the credits for this file in AUTHORS file in project root directory
*/
// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005
// Johannes Bergmeier <Johannes.Bergmeier@gmx.net>, (C) 2007
//
#include "gameopt.h"
#include <qlayout.h>

#include <kapp.h>
#include <kdialog.h>
#include <kmessagebox.h>
#include "roxdokuview.h"
#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>

#include "gameopt.moc"

namespace ksudoku {

GameOptionsDialog::GameOptionsDialog(QWidget* parent, bool dub, int type, int order)
	: QWidget(parent)
	, m_config(*KApplication::kApplication()->sessionConfig())
{
	QGridLayout *top_layout = new QGridLayout(this,2,2,5);
	//top_layout->addColSpacing (20,5);
	//top_layout->addRowSpacing (20,20);
	top_layout->setAutoAdd(true);
	
	btnsType       = new QVButtonGroup(i18n("Dimensions") , this);
	btnsOrder      = new QVButtonGroup(i18n("Order"     ) , this);
	btnsDifficulty = new QVButtonGroup(i18n("Difficulty") , this);
	btnssymmetry   = new QVButtonGroup(i18n("symmetry"  ) , this);

	rbType[0] = new QRadioButton(i18n("2D    (Sudoku)" ), btnsType, "2D (Sudoku)"    );
	rbType[1] = new QRadioButton(i18n("3D (Roxdoku)"), btnsType, "3D (Roxdoku)");
	rbType[2] = new QRadioButton(i18n("Custom: -None-"), btnsType, "Custom-shaped");
	rbType[2]->setEnabled(false);
	rbType[0]->setChecked(true);

	rbOrder[0] = new QRadioButton(i18n( "9"), btnsOrder,  "9");
	rbOrder[1] = new QRadioButton(i18n("16"), btnsOrder, "16");
	rbOrder[2] = new QRadioButton(i18n("25"), btnsOrder, "25");
	rbOrder[0]->setChecked(true);
	
	rbDifficulty[0] = new QRadioButton(i18n("Easy"   ), btnsDifficulty, "easy"   );
	rbDifficulty[1] = new QRadioButton(i18n("Medium" ), btnsDifficulty, "medium" );
	rbDifficulty[2] = new QRadioButton(i18n("Hard"   ), btnsDifficulty, "hard"   );
	rbDifficulty[3] = new QRadioButton(i18n("Hardest"), btnsDifficulty, "hardest");
	rbDifficulty[0]->setChecked(true);

	rbsymmetry[0] = new QRadioButton(i18n("Random"  ), btnssymmetry, "Random"  );
	rbsymmetry[1] = new QRadioButton(i18n("None"    ), btnssymmetry, "None"    );
	rbsymmetry[2] = new QRadioButton(i18n("Diagonal"), btnssymmetry, "Diagonal");
	rbsymmetry[3] = new QRadioButton(i18n("Central" ), btnssymmetry, "Central" );
	rbsymmetry[4] = new QRadioButton(i18n("4-way"   ), btnssymmetry, "4-way"   );
	rbsymmetry[0]->setChecked(true);

	readSettings();
	setType(type);
	setOrder(order);

	if(dub) {
		btnssymmetry->setEnabled(false);
		btnsDifficulty->setEnabled(false);
	}

	btnsDifficulty->show();
	btnsOrder->show();	
}

GameOptionsDialog::~GameOptionsDialog()
{
	// No need to delete something, as everything is a child of this
}


uint GameOptionsDialog::symmetry() const {
	if(type() != 0)
		return 1;
	
	for(int i=0; i<5; ++i)
		if(rbsymmetry[i]->isChecked())
			return i;
	return 0;
}

int GameOptionsDialog::difficulty() const {
	for(int i=0; i<4; ++i)
		if(rbDifficulty[i]->isChecked())
			return 2-i; //level between ??
	return 0;
}

uint GameOptionsDialog::order() const {
	if(rbOrder[1]->isChecked())
		return 16;
	if(rbOrder[2]->isChecked())
		return 25;
	return 9;
}

uint GameOptionsDialog::type() const {
	if(rbType[1]->isChecked())
		return 1;
	if(rbType[2]->isChecked())
		return 2;
	return 0;
}

QString GameOptionsDialog::shapeName() const {
	return m_shapeName;
}

void GameOptionsDialog::setSymmetry(int sym) {
	if(sym < 0) {
		btnssymmetry->setEnabled(false);
	} else {
		rbsymmetry[sym]->setChecked(true);
	}
}

void GameOptionsDialog::setDifficulty(int diff) {
	if(diff < -1)
		btnssymmetry->setEnabled(false);
	else if(diff > 2) {
		btnssymmetry->setEnabled(true);
		rbDifficulty[0]->setChecked(true);
	} else {
		btnssymmetry->setEnabled(true);
		rbDifficulty[2-diff]->setChecked(true);
	}
}

void GameOptionsDialog::setOrder(int order) {
	if(order < 0) {
		btnsOrder->setEnabled(false);
		return;
	}
	btnsOrder->setEnabled(true);
	int orderIndex = 0;
	switch(order){
		case  9:  orderIndex = 0; break;
		case 16:  orderIndex = 1; break;
		case 25:  orderIndex = 2; break;
	}
	rbOrder[orderIndex]->setChecked(true);
}

void GameOptionsDialog::setType(uint type) {
	rbType[type]->setChecked(true);
}

void GameOptionsDialog::setShapeName(const QString& name) {
	m_shapeName = name;
	if(name.isNull()) {
		rbType[2]->setText("Custom: -None-");
		rbType[2]->setEnabled(false);
	} else {
		rbType[2]->setText("Custom: "+name);
		rbType[2]->setEnabled(true);
	}
}

void GameOptionsDialog::readSettings()
{
	setDifficulty(m_config.readNumEntry("difficulty", 1));
	setType      (m_config.readNumEntry("type"      , 0));
	setSymmetry  (m_config.readNumEntry("Symmetry"  , 0));
	setOrder     (m_config.readNumEntry("order"     , 9));
}

void GameOptionsDialog::writeSettings()
{
// 	if(!m_success)
// 		return; //do not write settings
// 
	m_config.writeEntry("difficulty", difficulty());
	m_config.writeEntry("type"      , type()      );
	m_config.writeEntry("Symmetry"  , symmetry()  );
	m_config.writeEntry("order"     , order()     );
}


}
