/*
 * propagator.h - wrapper class around libsgp4sdp4
 */

#ifndef PROPAGATOR_H
#define PROPAGATOR_H

#include "sgp4sdp4/sgp4sdp4.h"

#define Cl       299792458.0   /* Speed of light m/sec */


class Propagator {
public:
	Propagator();
	~Propagator();
	// set the observers location
	void setQTH(double lon, double lat, double height);
	// set the satellite tle set
	void setTLE(char* line1, char* line2);
	void calc();		// calculate - time is NOW
	void calc(double daynum, bool calcAosLos=true); // calculate - use the time utc
  void calc(struct tm* utc, bool calcAosLos=true);
	double getVelocity() {return velocity;};
	double getAzimuth() {return azimuth;};
	double getElevation() {return elevation;};
	double getRange() {return range;};
	double getRangerate() {return range_rate;};
	double getLatitude() {return latitude;};
	double getLongitude() {return longitude;};
	double getHeight() {return height;};
	double getMA() {return ma;};
	double getFootprint() {return footprint;};
	double getAosLos() {return aoslos;};
  double getSquint() {return squint;};
	long long getDoppler(unsigned long long freq);
	double nextAosLos(double jul_utc);
  bool hasAos();
  char *daynum2String(double daynum);
  int getOrbitNum();
  /** reset the aos los time - needed for the propagation lists as these change that time! */
  void resetAosLos();
  double alon,alat;
  int squinttype;
  unsigned int catnr();
private:
	// tle lines
	char tle_lines[3][80];
	// Observers coordinates
	geodetic_t obs_geodetic;
	// tle_set, and local copy
	tle_t tle, localtle;
	// the results
  bool hasaos;
  bool aosHappens();
  double FindLOS(double daynum);
  double FindAOS(double daynum);
  double velocity;
	double azimuth;
  double elevation;
  double range;
  double range_rate;
  double latitude;
  double longitude;
  double height;
	double ma;
	double footprint;
	double aoslos;
  double squint;
  long orbnum;
};

#endif
