/***************************************************************************
                          xplanetconfig.cpp  -  description
                             -------------------
    begin                : Sat Sep 14 2002
    copyright            : (C) 2002 by Luc Langehegermann
    email                : lx2gt@qsl.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>

#include "xplanetconfig.h"

xplanetConfig::xplanetConfig(s_xplanet* parms, QWidget *parent, const char *name, WFlags fl) : xplanetConfigBase(parent,name,fl) {
  xplanetParameters=parms;
  QObject::connect(buttonCancel, SIGNAL(clicked()), this, SLOT(slotCancel()));
  QObject::connect(buttonOk, SIGNAL(clicked()), this, SLOT(slotOk()));
  backgroundEdit->setChecked(xplanetParameters->isBackground);
  parameterEdit->setText(xplanetParameters->parameters);
  updateIntervalEdit->setText(QString::number(xplanetParameters->updateInterval));
  enableXplanet->setChecked(!xplanetParameters->enabled);
}
xplanetConfig::~xplanetConfig(){
}
/** No descriptions */
void xplanetConfig::slotOk(){
  xplanetParameters->isBackground=backgroundEdit->isChecked();
  xplanetParameters->parameters=parameterEdit->text();
  xplanetParameters->updateInterval=updateIntervalEdit->text().toInt();
  xplanetParameters->enabled=!enableXplanet->isChecked();
  accept();
}
/** No descriptions */
void xplanetConfig::slotCancel(){
  reject();
}
