/***************************************************************************
 *   Copyright (C) 2004 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BABYLONPLUGIN_H
#define BABYLONPLUGIN_H

#include <dictionary/dictionaryplugin.h>

#include "libbab.h"

class KURL;
class QString;

class BabylonPlugin :public KTranslator::DictionaryPlugin
{
public:
    BabylonPlugin( QObject *parent, const char* name, const QStringList& );
    ~BabylonPlugin();

    // search the word in Babylon dictionary
    QString search( const QString &word );
    QWidget *confPage();
    void applyConf( QWidget * );

    bool babylonReady;

private:
    QString name;
    Babylon *babDic;
};


#endif /* BABYLONPLUGIN_H */

