/***************************************************************************
 *   Copyright (C) 2004 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "dictdplugin.h"
#include "dictzip.h"

#include <kgenericfactory.h>

#include <qfile.h>
#include <qregexp.h>
#include <qlabel.h>

#include <kprocio.h>

#ifndef NDEBUG

#include <kdebug.h>

#endif


K_EXPORT_COMPONENT_FACTORY( ktranslator_dictd,
                            KGenericFactory<DictdPlugin>( "ktranslator_dictd" ) )

DictdPlugin::DictdPlugin( QObject *parent, const char*, const QStringList &args )
            : KTranslator::DictionaryPlugin(parent, "Dictd" )
{
   KLocale::setMainCatalogue("ktranslator");
   dic = new DictZip( args[0] );
   dictName = args[1];
   setEnabled( true );
}

QString DictdPlugin::search( const QString &word )
{

  #ifndef NDEBUG

  kdDebug() << "Dictd Plugin search()" << endl;

  #endif

  QString result = dic->search( word );

  if( result.isEmpty() ) return QString ( "<dicName>%1</dicName><font color=#000000>%2</font>" ).arg( dictName ).arg( i18n( "Word not found" ) );

  int pos = result.find( '\n' );
  QString headword = result.left( pos );
  result = result.mid( pos ).stripWhiteSpace().replace( QRegExp( "^([v|n])" ), "<pos>\\1</pos>" ).replace( QRegExp( "^(adj)" ), "<pos>\\1</pos>" ).replace( '\n', "<br>" );
  result.replace( QRegExp( "\\{([^\\}]*)\\}" ), "<link>\\1</link>" );
  return QString( "<dicName>%1</dicName><headword>%2</headword><definition>%3</definition>" ).arg( dictName ).arg( headword ).arg( result );
}


QWidget *DictdPlugin::confPage()
{
  return new QLabel( "This plugin has no configurations", 0 );
}


void DictdPlugin::applyConf( QWidget * )
{
  return;
}
