/***************************************************************************
 *   Copyright (C) 2004 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ktrclipboard.h"
#include "ktrclipboard.moc"

#include <kapplication.h>
#include <qtimer.h>
#include <qstring.h>
#include <qclipboard.h>


ktrClipboard::ktrClipboard() : QObject ()
{
  clip = kapp->clipboard();
  timer = new QTimer();
  connect( timer, SIGNAL( timeout() ), this, SLOT( verify() ) );
  selection = "";
}


ktrClipboard::~ktrClipboard()
{
  delete timer;
}

void ktrClipboard::verify()
{
   if( selection.compare( clip->text( QClipboard::Selection ) ) )
   {
     selection = clip->text( QClipboard::Selection );
     emit selectionChanged();
   }
   timer->start( 200, true );
}


QString ktrClipboard::text()
{
   return selection;
}


void ktrClipboard::stop()
{
  timer->stop();
}


void ktrClipboard::start()
{
  selection = clip->text( QClipboard::Selection );
  timer->start( 200, true );
}
