/***************************************************************************
                          findRec.cpp  -  description
                             -------------------
    begin                : Mit Aug 7 2002
    copyright            : (C) 2002 by Jens Henrik Goebbert
    email                : jenshenrik.goebbert@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                          *
 ***************************************************************************/

#include "findRec.h"
#include <stdlib.h>
#include <math.h>
#include <qvaluelist.h>

/** Finds an appropriate block of text and delegates OCR to QOcrProgress
    1.  I try to find the size of the letter under the mouseclick
    2.  I try to find the letters before and behind the mouseclick-letter
    3.  I send back the size and the position of the rectangle on the image, where the word is
*/

FindRec::FindRec( QImage *img)
  :   word_x_right(-1 ),
      word_x_left (-1 ),
      word_y_down (-1 ),
      word_y_up   (-1 ),
      maxlwidth   (100),
      minlwidth   ( 2 ),
      maxlheight  (100),
      minlheight  ( 2 ),
      maxmiss     ( 3 ),
      rdiff       ( 0 ),
      gdiff       ( 0 ),
      bdiff       ( 0 )

{
  word_x      = -1 ;
  word_y      = -1 ;
  word_width  = -1 ;
  word_height = -1 ;
  word_letter =  0 ;  //of course there are no letters found yet

  image  = img;
  image_height=image->height()-1; //-1 because there are position 0 is the first pixel
  image_width =image->width() -1; //-1 because there are position 0 is the first pixel

//  parent = p;
}

FindRec::~FindRec()
{
}


/********************************************************************************
*                                                                               *
*                               findword()                                      *
*                                                                               *
*  This function trys to find a a word near the given point(xOfPoint,yOfPoint)  *
*  This function uses findletter() to recognise each letter and by that finds   *
*  the start and the end of a word                                              *
*********************************************************************************/
int FindRec::findword(int xOfPoint, int yOfPoint)
{
 int foundletter = false;
 int direction = 0; // 0 = left  /  1 = right
 int edgeletter[2]={0,0}; //tells what letter in the_letter-array is the most left/right one
 int stopleft = false,
     stopright= false;
 int distance;
 int sum_space,l;
 int letterdist;

// we have to find the first letter to start searching for the whole word !
 if(findletter(word_letter,xOfPoint,yOfPoint,yOfPoint,-1)) //1. letter found
 {
   //lets make the result visible
  // kdDebug()<<the_letter[word_letter].x_left<<" "<<the_letter[word_letter].space_left<<endl;
 //  parent->drawRec(the_letter[word_letter].x_left,the_letter[word_letter].x_right,
 //                  the_letter[word_letter].y_up  ,the_letter[word_letter].y_down,0 );
   word_letter++;



//************************ we search for the next letter *********************
   maxmiss    = maxlwidth; //only the first letter is found by the user... now we will 'miss' the letters more because we search for them
   letterdist = (the_letter[0].y_down - the_letter[0].y_up) /2;
   best_up    = the_letter[edgeletter[1]].y_up+1;
   best_down  = the_letter[edgeletter[1]].y_down-1;
   smallest_letterhight = the_letter[0].y_down - the_letter[0].y_up;

   while(true)//neverending-loop ... need to break out with 'break'
   {

    if(direction == 0 && stopleft == false) //search to the left until stopleft == true
    {
      if(findletter(word_letter, the_letter[edgeletter[0]].x_left, best_up, best_down, 0)) //one more letter found
      {
       foundletter = true;
       for(int check = 0; check < word_letter; check++) //check if the new letter does not cross any letter found before
        if( the_letter[word_letter].x_right-(the_letter[word_letter].x_right-the_letter[word_letter].x_left) > the_letter[check].x_left )
        {
         foundletter = false;
         stopleft = true;
         direction = 1;
         break;
        }
       if((the_letter[edgeletter[0]].x_left - the_letter[word_letter].x_right) > letterdist)
       {
        foundletter = false;
        stopleft = true;
        direction = 1;
       }
      }
      else
      {
       foundletter = false;
       stopleft = true;
       direction = 1;
      }
    }


    else if(stopright == false)              //search to the right
    {
     if(findletter(word_letter, the_letter[edgeletter[1]].x_right, best_up, best_down,1)) //one more letter found
     {
      foundletter = true;
      for(int check = 0; check < word_letter; check++) //check if the new letter does not cross any letter found before
       if( the_letter[word_letter].x_left+(the_letter[word_letter].x_right-the_letter[word_letter].x_left) < the_letter[check].x_right )
       {
          foundletter = false;
          stopright = true;
          direction = 0;
          break;
       }
      if((the_letter[word_letter].x_left - the_letter[edgeletter[1]].x_right) > letterdist)
      {
       foundletter = false;
       stopright = true;
       direction = 0;
      }
     }
     else
     {
      foundletter = false;
      stopright = true;
      direction = 0;
     }
    }

//***************** check if the new found letter is part of the word **************

    //ok...lets make a new letterdist
    if(direction == 0 && foundletter == true) //check for letters on the left side of the word
    {
     //First find the distance between the new (left letter of the word) and the its next one
     distance = the_letter[edgeletter[0]].x_left - the_letter[word_letter].x_right+1;
     the_letter[edgeletter[0]].space_left = distance;
     the_letter[word_letter].space_right= distance;

     if(   the_letter[word_letter].space_right <= letterdist
        && smallest_letterhight < (the_letter[word_letter].y_down - the_letter[word_letter].y_up) * 3
       )
     {
       //What is the avarage letterdist
       sum_space=0;
       for(l = 0; l < word_letter; l++)
         sum_space = sum_space + the_letter[l].space_left;
       letterdist = 2* (sum_space/word_letter); //this is the new maximum distance new letter is allowed to have to the word
       if(letterdist<3)letterdist = 3; //a letter distance lower than 3 makes for me no sence

       if(the_letter[word_letter].y_up+1   < best_up)   best_up   = the_letter[word_letter].y_up+1;
       if(the_letter[word_letter].y_down-1 < best_down) best_down = the_letter[word_letter].y_down-1;
       if(smallest_letterhight > the_letter[word_letter].y_down - the_letter[word_letter].y_up )
          smallest_letterhight = the_letter[word_letter].y_down - the_letter[word_letter].y_up;

       //the new letter is good and exepted as part of the word
       edgeletter[0]=word_letter;
       word_letter++;

       //lets make it visible
       //kdDebug()<<the_letter[edgeletter[0]].x_left<<endl;
//       parent->drawRec(the_letter[edgeletter[0]].x_left,the_letter[edgeletter[0]].x_right,
//                       the_letter[edgeletter[0]].y_up  ,the_letter[edgeletter[0]].y_down,0 );
     }
     else
     {
      stopleft = true;
      direction = 1;
     }
    }

    else if(foundletter == true)  //check for letters on the right side of the word
    {
     //First find the distance between the new (right letter of the word) and the its next one
     distance = the_letter[word_letter].x_left - the_letter[edgeletter[1]].x_right+1;
     the_letter[edgeletter[1]].space_right = distance;
     the_letter[word_letter].space_left  = distance;

     if(    the_letter[word_letter].space_left <= letterdist
         && smallest_letterhight < (the_letter[word_letter].y_down - the_letter[word_letter].y_up) *3
       )
     {
       //What is the avarage letterdist
       sum_space=0;
       for(l = 0; l < word_letter; l++)
        sum_space = sum_space + the_letter[l].space_right;
       letterdist = 2* (sum_space/word_letter); //this is the new maximum distance new letter is allowed to have to the word
       if(letterdist<3)letterdist = 3; //a letter distance lower than 3 makes for me no sence

       if(the_letter[word_letter].y_up+1   < best_up)   best_up   = the_letter[word_letter].y_up+1;
       if(the_letter[word_letter].y_down-1 < best_down) best_down = the_letter[word_letter].y_down-1;
       if(smallest_letterhight > the_letter[word_letter].y_down - the_letter[word_letter].y_up)
          smallest_letterhight = the_letter[word_letter].y_down - the_letter[word_letter].y_up;

       //the new letter is good and exepted as part of the word
       edgeletter[1] = word_letter; //now this found letter is the most right letter of the word
       word_letter++;

       //lets make it visible
       //kdDebug()<<the_letter[edgeletter[0]].x_left<<endl;
//       parent->drawRec(the_letter[edgeletter[1]].x_left,the_letter[edgeletter[1]].x_right,
  //                      the_letter[edgeletter[1]].y_up  ,the_letter[edgeletter[1]].y_down,0 );
     }
     else
     {
      stopright = true;
      direction = 0;
     }
    }

    // this is the only way to get out of this loop
    if((stopleft == true && stopright == true) || word_letter > 99) break;
   } // while
 }//if(findletter

 if(word_letter)
 {
  word_x_right = the_letter[0].x_right;
  word_x_left  = the_letter[0].x_left;
  word_y_down  = the_letter[0].y_down;
  word_y_up    = the_letter[0].y_up;
  for(l=0; l<word_letter; l++)
  {
    if(word_x_right < the_letter[l].x_right) word_x_right = the_letter[l].x_right;
    if(word_x_left  > the_letter[l].x_left ) word_x_left  = the_letter[l].x_left;
    if(word_y_down  < the_letter[l].y_down ) word_y_down  = the_letter[l].y_down;
    if(word_y_up    > the_letter[l].y_up   ) word_y_up    = the_letter[l].y_up;
  }
  //parent->drawRec(word_x_left,word_x_right,word_y_up  ,word_y_down,1 );
 }
 return(word_letter);
}


/********************************************************************************
*                                                                               *
*                               findletter()                                    *
*                                                                               *
*  This function trys to find a letter near the given point(xOfPoint,yOfPoint)  *
*  This function gets called by findword()                                      *
*                                                                               *
*********************************************************************************/
int FindRec::findletter(int lnow,const int xOfPoint, const int yOfPoint_up, const int yOfPoint_down,int direction)
{
/* ( 1. )
    Ok... I try to find the size of the letter under the mouseclick
      a)  I go to the left and the right of the mouseclick until the color has significally changed
            => I have a start/end of a horizontal line
          (if yOfPoint_extra is different to yOfPoint I move with a vertical line(yOfPoint,yOfPoint_extra) to
           the left/right to find the first colorChange)

      b)  I move that line up until the color of every pixel in the line does not change too much
            => I am just above the letter
          I move that line down until the color of every pixel in the line does not change too much
            => I am just under the letter

      c)  I do the same like b) with a vertikal line to find the left and the right of a virtual box around
          the letter.

      d) while-loop through b+c until I found a good box:
         I check if the whole box has no segnificent colorchange now.
         If it still has (because the box got wider in step c than it was is step b)
         I go through step b+c again with the new mouseclick-point as the left+up pixel of the found box

      e) now I check a few things (the original mouseclick is still not far away from the found box ...)

    I found the part of the image, in which the letter sits which was hit by the mouse
*/


/************************  1a)  ************************/
  QRgb pixelcolors[100];
  int ans,i,x,y,l = 0;
  int count = 0;
  int horiz_pr; // horizontal_pixel_right
  int horiz_pl; // horizontal_pixel_left
  int horiz_lu; // horizontal_line_under
  int horiz_ld; // horizontal_line_down
  int vert_ll;  // vertical_line_left
  int vert_lr;  // vertical_line_right
  int foundit,
      left_is_base,
      badnews = false;
  int tempX_left  = -1,
      tempX_right = -1,
      tempY_up    = -1,
      tempY_down  = -1;


  //search to the right for a high color-change
  if(direction != 0)  //we need a spezial routine for letters on the left
  {
   foundit = false;
   for(horiz_pr = xOfPoint, i=0;
       horiz_pr <= (xOfPoint+maxlwidth) && horiz_pr <= image_width && i<maxlwidth-1;
       horiz_pr++,i++)
   {
    for(y = yOfPoint_down; y >= yOfPoint_up; y--)
    {
     for( l=0; l<=i; l++ )
      pixelcolors[l] = image->pixel(horiz_pr-i+l,y);
     ans = checkColorChange(pixelcolors,l);
     if(ans >= 0) // there is a secnificent color-change
     {
      if(direction != 1)
       the_letter[lnow].x_right = horiz_pr;
      else //I know that we are searching for a letter on the left
       the_letter[lnow].x_left = horiz_pr;
      the_letter[lnow].y_up    = y-1;
      the_letter[lnow].y_down  = y+1;
      foundit = true;
     }
     if(foundit)break; //we found a good checkColorChange -> lets go out of this for-loop
    }
    if(foundit)break;
   }
   // if the for-loop never stopped with a 'break;' we have to deal with this problem
   if (foundit == false) badnews = true;
  }

  //search to the left for a high color-change
  if(direction != 1)  //we need a spezial routine for letters on the right
  {
   foundit = false;
   for(horiz_pl = xOfPoint, i=0;
       horiz_pl >= (xOfPoint-maxlwidth) && horiz_pl >= 0 && i<maxlwidth-1;
       horiz_pl--,i++)
   {
    for(y = yOfPoint_down; y >= yOfPoint_up; y--)
    {
     for( l=0; l<=i; l++ )
      pixelcolors[l] = image->pixel(horiz_pl+i-l,y);
     ans = checkColorChange(pixelcolors,l);
     if(ans >= 0) // there is a segnificent color-change
     {
       if(direction != 0)
         the_letter[lnow].x_left = horiz_pl;
       else
         the_letter[lnow].x_right = horiz_pl;
       the_letter[lnow].y_up   = y-1;
       the_letter[lnow].y_down = y+1;
       foundit = true;
     }
     if(foundit)break; //we found a good checkColorChange -> lets go out of this for-loop
    }
    if(foundit)break;
   }
   // if the for-loop never stopped with a 'break;' we have to deal with this problem
   if (foundit == false) badnews = true;
  }

  //If we know that we are searching a letter on the left side... this function calculates the most left point of the new letter
  if(direction == 0)
  {
    foundit = false;
    for(vert_ll = the_letter[lnow].x_right-1;
        vert_ll >= (the_letter[lnow].x_right-maxlwidth) && vert_ll >= 0;
        vert_ll--)
    {
      for(y = yOfPoint_up, i=0;
        y < yOfPoint_down && i<maxlwidth-1;
        y++, i++)
          pixelcolors[i] = image->pixel(vert_ll,y);
      ans = checkColorChange(pixelcolors,l);
      if(ans < 0) // there is no segnificent color-change
      {
       the_letter[lnow].x_left = vert_ll;
       foundit = true;
       break;
      }
    }
    // if the for-loop never stopped with a 'break;' we have to deal with this problem
    if (foundit == false) badnews = true;
  }


  //If we know that we are searching a letter on the right side... this function calculates the most right point of the new letter
  if(direction == 1)  //we need a spezial routine for letters on the right
  {
    foundit = false;
    for(vert_lr  = the_letter[lnow].x_left+1;
        vert_lr <= (the_letter[lnow].x_left+maxlwidth) && vert_lr <= image_width;
        vert_lr++)
    {
      for(y = yOfPoint_up, i=0;
          y < yOfPoint_down && i<maxlwidth-1;
          y++, i++)
            pixelcolors[i] = image->pixel(vert_lr,y);
      ans = checkColorChange(pixelcolors,l);
      if(ans < 0) // there is no segnificent color-change
      {
        the_letter[lnow].x_right = vert_lr;
        foundit = true;
        break;
      }
    }
    // if the for-loop never stopped with a 'break;' we have to deal with this problem
    if (foundit == false) badnews = true;
  }

  if( (xOfPoint - the_letter[0].x_left)  <  (the_letter[0].x_right - xOfPoint) )
   left_is_base = true;
  else
   left_is_base = false;


while(true && badnews == false) //we break out of this with a 'break'
{
/************************  1b)  ************************/

  //search upwards until there are no segnificent color-changes in the line
  foundit = false;
  for(horiz_lu = the_letter[lnow].y_up;
      horiz_lu >= (the_letter[lnow].y_up-maxlheight) && horiz_lu >= 0;
      horiz_lu--)
  {
    for(x = the_letter[lnow].x_left, i=0;
        x <= the_letter[lnow].x_right && i<maxlwidth-1;
        x++,i++)
          pixelcolors[i] = image->pixel(x, horiz_lu);

    ans = checkColorChange(pixelcolors,i);
    if(ans < 0) // there is no secnificent color-change
    {
      the_letter[lnow].y_up = horiz_lu;
      foundit = true;
      break;
    }
  }
  // if the for-loop never stopped with a 'break;' we have to deal with this problem
  if (foundit == false)
  {
    badnews = true;
    break; //go out of the while-loop
  }

  //search downwards until there are no segnificent color-changes in the line
  foundit = false;
  for(horiz_ld = the_letter[lnow].y_down;
      horiz_ld <= (the_letter[lnow].y_down+maxlheight) && horiz_ld < image_height;
      horiz_ld++)
  {
    for(x = the_letter[lnow].x_left, i=0;
        x <= the_letter[lnow].x_right && i<maxlwidth-1;
        x++, i++)
          pixelcolors[i] = image->pixel(x, horiz_ld);
    ans = checkColorChange(pixelcolors,i);
    if(ans < 0) // there is no segnificent color-change
    {
      the_letter[lnow].y_down = horiz_ld;
      foundit = true;
      break;
    }
  }
  // if the for-loop never stopped with a 'break;' we have to deal with this problem
  if (foundit == false)
  {
    badnews = true;
    break; //go out of the while-loop
  }


/************************  1c)  ************************/

  if(left_is_base == true)
  {
    //search left until there are no segnificent color-changes in the line
    foundit = false;
    for(vert_ll =  the_letter[lnow].x_left;
        vert_ll >= the_letter[lnow].x_left-maxlwidth && vert_ll > 0 && foundit == false;
        vert_ll--)
    {
      for(y = the_letter[lnow].y_up, i=0;
          y <= the_letter[lnow].y_down && i<maxlwidth-1;
          y++, i++)
           pixelcolors[i] = image->pixel(vert_ll,y);
      ans = checkColorChange(pixelcolors,i);
      if(ans < 0) // there is no segnificent color-change
      {
        the_letter[lnow].x_left = vert_ll;
        foundit = true;
      }
    }
    // if the for-loop never stopped with a 'break;' we have to deal with this problem
    if (foundit == false)
    {
      badnews = true;
      break; //go out of the while-loop
    }

    //search right until there are no segnificent color-changes in the line
    foundit = false;
    for(vert_lr = the_letter[lnow].x_left+1;
        vert_lr < the_letter[lnow].x_left+maxlwidth && vert_lr < image_width && foundit == false;
        vert_lr++)
    {
      for(y = the_letter[lnow].y_up, i=0;
          y <= the_letter[lnow].y_down && i<maxlwidth-1;
          y++, i++)
            pixelcolors[i] = image->pixel(vert_lr,y);
      ans = checkColorChange(pixelcolors,i);
      if(ans < 0) // there is no segnificent color-change
      {
        the_letter[lnow].x_right = vert_lr;
        foundit = true;
      }
    }
    // if the for-loop never stopped with a 'break;' we have to deal with this problem
    if (foundit == false)
    {
      badnews = true;
      break; //go out of the while-loop
    }
  }
  else //right_is_base
  {
    //search left until there are no segnificent color-changes in the line
    foundit = false;
    for(vert_ll =  the_letter[lnow].x_right-1;
        vert_ll >= the_letter[lnow].x_right-maxlwidth && vert_ll > 0 && foundit == false;
        vert_ll--)
    {
      for(y = the_letter[lnow].y_up, i=0;
          y <= the_letter[lnow].y_down && i<maxlwidth-1;
          y++, i++)
           pixelcolors[i] = image->pixel(vert_ll,y);
      ans = checkColorChange(pixelcolors,i);
      if(ans < 0) // there is no segnificent color-change
      {
        the_letter[lnow].x_left = vert_ll;
        foundit = true;
      }
    }
    // if the for-loop never stopped with a 'break;' we have to deal with this problem
    if (foundit == false)
    {
      badnews = true;
      break; //go out of the while-loop
    }

    //search right until there are no segnificent color-changes in the line
    foundit = false;
    for(vert_lr = the_letter[lnow].x_right;
        vert_lr < the_letter[lnow].x_right+maxlwidth && vert_lr < image_width && foundit == false;
        vert_lr++)
    {
      for(y = the_letter[lnow].y_up, i=0;
          y <= the_letter[lnow].y_down && i<maxlwidth-1;
          y++, i++)
            pixelcolors[i] = image->pixel(vert_lr,y);
      ans = checkColorChange(pixelcolors,i);
      if(ans < 0) // there is no segnificent color-change
      {
        the_letter[lnow].x_right = vert_lr;
        foundit = true;
      }
    }
    // if the for-loop never stopped with a 'break;' we have to deal with this problem
    if (foundit == false)
    {
      badnews = true;
      break; //go out of the while-loop
    }
  }

/*
    now we know:
                 y_up
               ----*----
               |       |
        x_left *       * x_right
               |       |
               ----*----
                y_down

    of the box around the letter which the mouse hit
*/
/************** check the result *************/

  if(   (the_letter[lnow].x_right - the_letter[lnow].x_left) < minlwidth
     && (the_letter[lnow].y_down  - the_letter[lnow].y_up  ) < minlheight )
     { badnews = true; break; }

  // --- ( 1 check ) ---
  //we do not want to find areas smaller than minlwidth/minlheight
  if((the_letter[lnow].x_right - the_letter[lnow].x_left) < minlwidth)
   if(the_letter[lnow].x_left > 0)
   { the_letter[lnow].x_left = the_letter[lnow].x_left -1;}
   else
   {
    if(the_letter[lnow].x_right < image_width)
      the_letter[lnow].x_right = the_letter[lnow].x_right +1;
   }
  if((the_letter[lnow].y_down - the_letter[lnow].y_up) < minlheight)
   if(the_letter[lnow].y_up > 0)
   { the_letter[lnow].y_up = the_letter[lnow].y_up -1;}
   else
   {
    if(the_letter[lnow].y_down < image_height)
      the_letter[lnow].y_down = the_letter[lnow].y_down +1;
   }

  // --- ( 2 check ) ---
  //the box has to get bigger if we go through the while-loop again ... not smaller
  if(tempX_left != -1) //ok... this is not the first go through the while-loop
  {
   if(the_letter[lnow].x_left > tempX_left )
    if(tempX_left > 0)
      { the_letter[lnow].x_left = tempX_left -1; }
    else
      { the_letter[lnow].x_left = 0; }

   if(the_letter[lnow].x_right < tempX_right )
    if(tempX_right < image_width)
      { the_letter[lnow].x_right = tempX_right +1; }
    else
      { the_letter[lnow].x_right = image_width; }

   if(the_letter[lnow].y_down < tempY_down )
    if(tempY_down < image_height)
     { the_letter[lnow].y_down = tempY_down+1; }
    else
     { the_letter[lnow].y_down = image_height;}

   if(the_letter[lnow].y_up > tempY_up)
    if(tempY_up > 0)
     { the_letter[lnow].y_up = tempY_up -1;}
    else
     { the_letter[lnow].y_up = 0; }
  }

/******** 2 possibilities to get out of the while-loop (exept for 'badnews-breaks' everywhere) *********/

  // --- ( 1 ) ---
  //do we have to make the box bigger or is it ok like this ?
  // here we can get out of the while-loop
  if( the_letter[lnow].x_left == tempX_left
   && the_letter[lnow].x_right== tempX_right
   && the_letter[lnow].y_up   == tempY_up
   && the_letter[lnow].y_down == tempY_down)
   {
     //check if the mouseclick is too far away from the found box
     //(user is allowed to miss the letter by 'maxmiss')
     if(    (the_letter[lnow].x_left - xOfPoint ) > maxmiss
        ||  (xOfPoint    - the_letter[lnow].x_right) > maxmiss
        ||  (yOfPoint_up - the_letter[lnow].y_down ) > maxmiss
        ||  (the_letter[lnow].y_up - yOfPoint_up   ) > maxmiss
       ) badnews = true;
     break;
   }

  // --- ( 2 ) ---
  //better we have an emergency exit out of this loop
  if(count > maxlwidth)
  {
   badnews = true;
   break;
  }
  count++;

  // write the current status to the temp-variable to check the change after the next loop
  tempX_left = the_letter[lnow].x_left ;
  tempX_right= the_letter[lnow].x_right;
  tempY_up   = the_letter[lnow].y_up   ;
  tempY_down = the_letter[lnow].y_down ;

 }//while

 if(badnews == false)
   { return(true); }
 else
   { return(false); }
}

/********************************************************************************
*                                                                               *
*                               checkColorChange()                              *
*                                                                               *
*  This function gets an array of QRgb's(pixels) and searches for a segnificent *
*  colorchange. To better recognise anti-alising fonts this function needs      *
*  a lot more time.                                                             *
*  The return-value is the position of the segnificant colorchange .. if there  *
*  is none the return-value is -1.                                              *
*********************************************************************************/
int FindRec::checkColorChange(const QRgb * c, const int pixelcount)
    {
/*     int red_new, green_new, blue_new;
     int red_old, green_old, blue_old;
     for(int pos=1; pos<pixelcount; pos++)
     {
       red_new   = qRed(   c[pos] );
       green_new = qGreen( c[pos] );
       blue_new  = qBlue(  c[pos] );
       red_old   = qRed(   c[pos-1] );
       green_old = qGreen( c[pos-1] );
       blue_old  = qBlue(  c[pos-1] );
       if(     abs(red_old   - red_new   )  > rdiff
           ||  abs(green_old - green_new )  > gdiff
           ||  abs(blue_old  - blue_new  )  > bdiff
         ) return(pos); //there is a significant colorchange at position 'pos'
     }
      return(-1);
  }
*/
     enum RGBcolor {red=0,green=1,blue=2};
     enum RGBposition {high=0,middle=1,low=2};

     struct colorpart
     {
       RGBcolor colortype;
       int value;
     } pixelcolor[3];

     int oldcolor[3];
     int c_red, c_green, c_blue;

     oldcolor[red]   = qRed(   c[0] )+1;   //a division with 0 wouldnt be so good
     oldcolor[green] = qGreen( c[0] )+1;   //a division with 0 wouldnt be so good
     oldcolor[blue]  = qBlue(  c[0] )+1;   //a division with 0 wouldnt be so good

     //Bridnesscheck
     for(int pos=1; pos<pixelcount; pos++)
     {
       //sort red,green,blue to high,middle,low
       c_red   = qRed(   c[pos] )+1; //a division with 0 wouldnt be so good
       c_green = qGreen( c[pos] )+1; //a division with 0 wouldnt be so good
       c_blue  = qBlue(  c[pos] )+1; //a division with 0 wouldnt be so good

       if( c_green > c_red )
       {
          pixelcolor[high].value     = c_green;
          pixelcolor[high].colortype = green;
          pixelcolor[middle].value     = c_red;
          pixelcolor[middle].colortype = red;
       }
       else
       {
          pixelcolor[high].value     = c_red;
          pixelcolor[high].colortype = red;
          pixelcolor[middle].value     = c_green;
          pixelcolor[middle].colortype = green;
       }

       if( c_blue <= pixelcolor[middle].value)
        {
          pixelcolor[low].value     = c_blue;
          pixelcolor[low].colortype = blue;
        }
       else
         if( c_blue <= pixelcolor[high].value )
         {
           pixelcolor[low].value     = pixelcolor[middle].value;
           pixelcolor[low].colortype = pixelcolor[middle].colortype;
           pixelcolor[middle].value  = c_blue;
           pixelcolor[middle].colortype = blue;
         }
         else
         {
           pixelcolor[low].value     = pixelcolor[middle].value;
           pixelcolor[low].colortype = pixelcolor[middle].colortype;
           pixelcolor[middle].value     = pixelcolor[high].value;
           pixelcolor[middle].colortype = pixelcolor[high].colortype;
           pixelcolor[high].value  = c_blue;
           pixelcolor[high].colortype = blue;
         }

         //Is the colordifference of the color with the highest value to big ?
         if( abs(pixelcolor[high].value - oldcolor[pixelcolor[high].colortype]) > 50)
          return(pos);
         //Is the percentige difference between old and new the same in red,green and blue
         if(   fabs( (   abs(pixelcolor[high].value - oldcolor[pixelcolor[high].colortype])
                       / ((float)oldcolor[pixelcolor[high].colortype] / oldcolor[pixelcolor[middle].colortype]) )
                       - abs(oldcolor[pixelcolor[middle].colortype] - pixelcolor[middle].value)   ) > 10
            || fabs( (   abs(pixelcolor[high].value - oldcolor[pixelcolor[high].colortype])
                       / ((float)oldcolor[pixelcolor[high].colortype] / oldcolor[pixelcolor[low].colortype]) )
                       - (oldcolor[pixelcolor[low].colortype] - pixelcolor[low].value)   ) > 10
         )
          return(pos); //there is a significant colorchange at position 'pos'

       oldcolor[pixelcolor[high].colortype]   = pixelcolor[high].value;
       oldcolor[pixelcolor[middle].colortype] = pixelcolor[middle].value;
       oldcolor[pixelcolor[low].colortype]    = pixelcolor[low].value;
     }
   return(-1);
  }
