using System;
using System.Collections;

namespace Data
{

public class Group
{
    public AccountType Type;
    public string Name;
    public decimal DatedDebit;
    public decimal DatedCredit;

    public Group (AccountType type)
    {
        this.Type = type;
        this.Name = type.ToString ();
    }

    public decimal Debit
    {
        get
        {
            decimal debit = 0;

            foreach (Account account in Children)
            {
                debit += account.Debit;
            }

            return debit;
        }
    }

    public decimal Credit
    {
        get
        {
            decimal credit = 0;

            foreach (Account account in Children)
            {
                credit += account.Credit;
            }

            return credit;
        }
    }

    public decimal Balance
    {
        get
        {
            if ( Type == AccountType.Asset || Type == AccountType.Expense )
                return Debit - Credit;
            else
                return Credit - Debit;
        }
    }

    public decimal DatedBalance
    {
        get
        {
            if ( Type == AccountType.Asset || Type == AccountType.Expense )
                return DatedDebit - DatedCredit;
            else
                return DatedCredit - DatedDebit;
        }
    }

    public decimal DatedDebitBalance
    {
        get
        {
            if (DatedDebit > DatedCredit)
                return DatedDebit - DatedCredit;
            else
                return 0;
        }
    }

    public decimal DatedCreditBalance
    {
        get
        {
            if (DatedCredit > DatedDebit)
                return DatedCredit - DatedDebit;
            else
                return 0;
        }
    }

    public ArrayList Children = new ArrayList ();
}


}

