using System;
using System.Collections;
using System.Xml;
using System.Xml.Serialization;
using System.Xml.Schema;

namespace Data
{

[XmlRoot]
public class Kurush : ICloneable
{
    [XmlAttribute] public int Version;

    [XmlAttribute] public string Title = "";
    [XmlAttribute] public DateTime ReportStart =
        new DateTime (DateTime.Now.Year, 1, 1);

    [XmlAttribute] public int EntryCounter = 0;
    [XmlAttribute] public int AccountCounter = 0;

    [XmlArrayItem(Type=typeof(Account))]
    public ArrayList Accounts = new ArrayList ();

    public object Clone ()
    {
        Kurush obj = new Kurush ();

        obj.EntryCounter = EntryCounter;
        obj.AccountCounter = AccountCounter;
        obj.Version = Version;
        obj.Title = (string) Title.Clone ();
        obj.ReportStart = ReportStart;

        foreach (Account account in Accounts)
        {
            obj.Accounts.Add (account.Clone ());
        }

        return obj;
    }
}


}
