using System;
using System.Collections;
using Gtk;
using GtkExtra;
using Gnome;


namespace Kurush
{

public class Kurush
{
    public static string Interface = "Interface.glade";
    private static ArrayList windows = new ArrayList ();
    private static Settings settings = new Settings ("Settings");
    public static string Split = "(Split)";
    public static string Extension = ".kurush";
    public static OpenRecent OpenRecentManager;
    public static PrintConfig PrConfig;


    public static int WindowCount
    {
        get
        {
            return windows.Count;
        }
    }

    public static SettingKeys Keys
    {
        get
        {
            return settings.Keys;
        }
    }


    public static int Main (string[] args)
    {
#if DEBUG

        System.Diagnostics.Debug.Listeners.Add(
            new System.Diagnostics.TextWriterTraceListener(
                Console.Out));
        System.Diagnostics.Debug.AutoFlush = true;
#endif

        Gdk.Threads.Init ();
        Application.Init ();

        PrConfig = PrintConfig.Default ();

        GtkExtra.Format.Init (Keys.FormatInfo);
        OpenRecentManager = new OpenRecent (Keys.OpenRecentHistory, 10);

        OpenRecentManager.Activated +=
            new OpenRecentActivateHandler (OpenRecentActivated);

        if (OpenRecentManager.LastFile != null)
            NewMainWindow (OpenRecentManager.LastFile);
        else
            NewMainWindow ();

        Gdk.Threads.Enter ();
        Application.Run ();
        settings.Save ();
        Gdk.Threads.Leave ();
        return 0;
    }

    public static MainWindow NewMainWindow (string filename)
    {
        MainWindow window = new MainWindow (filename);
        windows.Add (window);
        return window;
    }

    public static MainWindow NewMainWindow ()
    {
        MainWindow window = new MainWindow ();
        windows.Add (window);
        return window;
    }


    public static void CloseMainWindow (MainWindow window)
    {
        windows.Remove (window);
        window.Close ();

        if (windows.Count == 0)
            Application.Quit ();
    }



    private static void OpenRecentActivated (string filename)
    {
        NewMainWindow (filename);
    }

    public static void Quit ()
    {
        bool quit = true;

        MainWindow [] copyWindows = (MainWindow[])
                                    windows.ToArray (typeof(MainWindow));

        foreach (MainWindow window in copyWindows)
        {
            if (window.CanClose)
            {
                windows.Remove (window);
                window.Close ();
            }
            else
            {
                quit = false;
                break;
            }
        }

        if (quit)
            Application.Quit ();
    }

}

}
