using System;
using Gtk;
using Glade;

namespace Kurush
{

public class PreferencesDialog : TopLevel
{
    [Glade.Widget] private Entry dateFormatEntry;
    [Glade.Widget] private Entry dateSepEntry;
    [Glade.Widget] private SpinButton decimalSpinButton;

    public PreferencesDialog (Window parent)
            : base ("preferencesDialog", parent)
    {
        decimalSpinButton.Value = Kurush.Keys.FormatInfo.DecimalDigits;
        dateSepEntry.Text = Kurush.Keys.FormatInfo.DateSeparator;
        dateFormatEntry.Text = Kurush.Keys.FormatInfo.ShortDatePattern;
    }

    protected override void SelfResponse (object obj, ResponseArgs args)
    {
        if (args.ResponseId == ResponseType.Ok)
        {
            Kurush.Keys.FormatInfo.DateSeparator = dateSepEntry.Text;
            Kurush.Keys.FormatInfo.ShortDatePattern = dateFormatEntry.Text;

            Kurush.Keys.FormatInfo.DecimalDigits = Convert.ToInt32(decimalSpinButton.Value);
        }

        Self.Destroy ();
    }
}

}
