using System;
using Gtk;
using GtkExtra;

namespace Kurush
{

public class SummaryPrintDialog : TopLevel
{
    private Data.Base dataBase;


    [Glade.Widget] private RadioButton detailsRadioButton;
    [Glade.Widget] private Table accountDetailsTable;

    private DateTimeEntry begDateEntry;
    private DateTimeEntry endDateEntry;

    private EventHandler AccountEntryChangedHandler;
    private WidgetEntry begAccountEntry;
    private WidgetEntry endAccountEntry;

    private FrameManager owner;

    public SummaryPrintDialog (FrameManager owner)
            : base ("summaryPrintDialog", owner.TopLevel)
    {
        this.owner = owner;
        this.dataBase = owner.DataBase;

        AccountEntryChangedHandler = new EventHandler (AccountEntryChanged);

        begDateEntry = new DateTimeEntry (gxml["begDateEntry"] as Entry);
        begDateEntry.Value = dataBase.ReportStart;
        endDateEntry = new DateTimeEntry (gxml["endDateEntry"] as Entry);

        begAccountEntry = new WidgetEntry (owner.AccountsPopup);
        begAccountEntry.AutoSize = true;
        begAccountEntry.Show ();
        accountDetailsTable.Attach (begAccountEntry, 1, 4, 1, 2,
                                    AttachOptions.Expand | AttachOptions.Fill,
                                    AttachOptions.Shrink,
                                    0,0);

        begAccountEntry.PopUp += new EventHandler (AccountEntryPopUp);
        begAccountEntry.PopDown += new EventHandler (AccountEntryPopDown);

        endAccountEntry = new WidgetEntry (owner.AccountsPopup);
        endAccountEntry.AutoSize = true;
        endAccountEntry.Show ();
        accountDetailsTable.Attach (endAccountEntry, 1, 4, 2, 3,
                                    AttachOptions.Expand | AttachOptions.Fill,
                                    AttachOptions.Shrink,
                                    0,0);

        endAccountEntry.PopUp += new EventHandler (AccountEntryPopUp);
        endAccountEntry.PopDown += new EventHandler (AccountEntryPopDown);
    }

    private WidgetEntry currentEntry;

    private void AccountEntryPopUp (object obj, EventArgs args)
    {
        WidgetEntry entry = obj as WidgetEntry;

        owner.AccountsView.Selection.Changed += AccountEntryChangedHandler;
        entry.Content = null;
        currentEntry = entry;
    }

    private void AccountEntryPopDown (object obj, EventArgs args)
    {
        owner.AccountsView.Selection.Changed -= AccountEntryChangedHandler;
    }

    private void AccountEntryChanged (object obj, EventArgs args)
    {
        SummaryNode node = owner.AccountsView.GetSelected () as SummaryNode;

        if (node != null)
        {
            currentEntry.Active = false;
            currentEntry.Content = node;
            currentEntry.Entry.Text = node.Name;
        }
    }

    protected override void SelfResponse (object obj, ResponseArgs args)
    {
        Self.Destroy ();

        if (args.ResponseId == ResponseType.Ok)
        {
            if (detailsRadioButton.Active)
            {
                //FIX ME: Need a thread here
                bool start = false;

                Data.Account begAccount = null;
                Data.Account endAccount = null;

                SummaryNode begNode = begAccountEntry.Content as SummaryNode;
                SummaryNode endNode = endAccountEntry.Content as SummaryNode;

                if (begNode != null)
                {
                    if (begNode.Account != null)
                        begAccount = begNode.Account;
                    else
                        begAccount = begNode.Group.FirstAccount;
                }
                else
                    start = true;

                if (endNode != null)
                {
                    if (endNode.Account != null)
                        endAccount = endNode.Account;
                    else
                        endAccount = endNode.Group.LastAccount;
                }

                foreach (Data.Group group in dataBase.Groups)
                {
                    foreach (Data.Account account in group.Children)
                    {
                        if (account == begAccount)
                            start = true;

                        if (start)
                            new DetailsReport (dataBase, account,
                                               begDateEntry.Value, endDateEntry.Value);

                        if (account == endAccount)
                            return;
                    }
                }

            }
            else
                new SummaryReport (dataBase);
        }

    }

    private void on_detailsRadioButton_toggled (object obj, EventArgs args)
    {
        accountDetailsTable.Sensitive = detailsRadioButton.Active;
    }


}

}
