/***************************************************************************
                          kvdr.h  -  description
                             -------------------
    begin                : Sat Aug  5 13:32:09 MEST 2000
    copyright            : (C) 2000 by Guido
    email                : gfiala@s.netic.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KVDR_H
#define KVDR_H                                               -----

#define QT_CLEAN_NAMESPACE
#include <config.h>

#include <qwidget.h>
#include <qstring.h>
#include <qtimer.h>
#include <qfile.h>
#include <qcursor.h>

#include <kapp.h>
#include <kaccel.h>
#include <kprocess.h>
#include <kcmdlineargs.h>

#include "svdrpc.h"
#include "ckvdrcfg.h"

#define _STRUCT_TIMESPEC
#undef __need_timeval
#undef __USE_POSIX199309
#define _LINUX_TIME_H
#include <linux/videodev.h>

#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <sys/mman.h>
#include <unistd.h>

#define HAVE_SYS_SOUNDCARD_H 1
#ifdef HAVE_SOUNDCARD_H
# include <soundcard.h>
#endif
#ifdef HAVE_SYS_SOUNDCARD_H
# include <sys/soundcard.h>
#endif

// includes needed for X stuff
#include <X11/X.h>
#include <X11/Xmd.h>

#define DEFAULT_VIDEO_DEV "/dev/video"

#define HAVE_LIBXV//will not work without so far, ToDo: put it into configure-scripts

#ifdef HAVE_LIBXV
class XvDisplayer;
#endif

#define USE_DPMS 1 //uncomment this line if wished and add "-lDPMS" in linking options
//#define USE_VFAT_FS 1 //uncomment if you store your images at VFAT filesystems
                        //that avoids using the colon ":" in the name...

#define MAXCLIPRECTS 100

typedef struct CRect
{
  signed short x,y,width,height;
};

class Kvdr : public QWidget
{
  Q_OBJECT
  public:
    Kvdr(QWidget* parent=0, const char *name=0);
    ~Kvdr();
    bool isPAL,ismute,isXv;
    int XvDi;
    float video_aspect_ratio, aspect_ratio;
    QString basename;//set by dialog & .kdvrrc
    int brightness, colour, hue, contrast, VidDev;//set by dialog & .kdvrrc
    int i_size_x, i_size_y, i_g_size_x, i_g_size_y, i_jpg_qual;//set by dialog & .kdvrrc
    unsigned int vdr_port, Volume, FrontRear, MixerChannel;//set by dialog & .kdvrrc
    int display_width,display_height;
    QStrList mixerdevlist;
    QString StrMixerChannel;
    cSVDRPC *svdrpc;
    QTimer AdjustSizeTimer;//used to correct geometry after resize-Events...
    void SetVolume(int Volume, QString MGroup, int FrontRearBalance);
    void save_kvdrrc();
    QTimer CheckClippingTimer;//used to check Clipping on a regular basis - workaround!
    int bpp, palette;
    void *base;
    void doClipping(bool doit=1);
    QFile video_fd;
    QFile multivideo_fd[4];
  private:
    bool vdr_mb_shown,kde_sc_was_running;
    QTimer RefreshDisplayTimer;//used to refresh Display out of doClipping()
    KAccel *userKeys;
    ckvdrcfg *cnfdlg;
    QRect prevSize,saveGeom,savePos;
    QCursor orgCursor;
    QPoint orgpos;
    bool isfullscreen, stayontop, ovlstat, store, dirty_position;
    bool res_was_switched, RefreshEntireScreen;
    bool ismultivideo, use_dvb_mixer;
    int lp_x,lp_y,pip_pos,pip_dev,o_cursor;
    int didRefresh,num_of_consecutive_expose_events;
    int old_vol;
    Display *disp;
    int ss_timeout,ss_interval,ss_prefer_blanking,ss_allow_exposures;
    int vdr_timeout;
#ifdef USE_DPMS
    CARD16 dpms_state;
#endif
#ifdef HAVE_LIBXV
    char *xv_mem[4];
    struct video_mmap *xv_vm[4];
 	  struct video_mbuf *xv_mb[4];
    bool stopXv;
		XvDisplayer *Xvdsp;
#endif
    int (*oldXErrorHandler)();
    Window root;
    int screen;
    int newVisibility;
    int vm_count;
    BOOL dpms_on;
    int f_size_x, f_size_y, f_x, f_y;
    void GetNextFilename(QString& fn, const char* basename, const char* ext);
    void moveEvent(QMoveEvent*);
    void resizeEvent(QResizeEvent*);
		void hideEvent(QHideEvent*);
		void showEvent(QShowEvent*);
    void refreshDisplay(const QRect& rect);
    KCmdLineArgs *args;
    CRect cr[MAXCLIPRECTS];
    CRect cr1[MAXCLIPRECTS];
    void addCRect(int &cc, int x, int y, int w, int h);
    void load_kvdrrc();
    //overlay capabilities
    bool OvlG(int SizeX, int SizeY, int PosX, int PosY);
    bool OvlC(int ClipCount, CRect *cr);
    bool OvlO(bool Value);
    bool GImg(const char *FileName, bool Jpeg, int Quality, int SizeX, int SizeY);
    bool ovlFbSet, ovlGeoSet, ovlStat;
    int  ovlFbSizeX,ovlFbSizeY,ovlBpp,ovlPalette;
    int  ovlBrightness,ovlColour,ovlHue,ovlContrast,ovlClipCount;
    int  ovlSizeX, ovlSizeY, ovlPosX, ovlPosY;
		int  rem_hdisplay,rem_vdisplay;
    struct video_clip ovlClipRects[MAXCLIPRECTS][4];
    //some functions and variables for the mixer:
    /* The following mixer device would be set to record mode and
       controls the rear speaker volume: */
    #define REAR "IGain"
    QFile mix;  // "/dev/mixer" File handle
    int 	dev;  // Mixer Volume Device
    int	  rdev; // Mixer Rear-Volume Device
    char  mixer_devices[128];

		char* InitMixer(void);
    void SetMixer(const char *device, int FrontVolume, int RearVolume);
    void ExitMixer(void);
public: //for the configuration dialog only:
    bool OvlF(int SizeX, int SizeY, int FbAddr, int Bpp, int Palette);
    bool OvlP(int Brightness, int Colour, int Hue, int Contrast);
protected:
    bool x11Event( XEvent *event );
    void mouseMoveEvent( QMouseEvent *event );
    int crs_hide_cnt;
#define CSR_HIDE_TIME 20
protected slots:
    void QuitSLOT();
    void HelpSLOT();
    void MuteSLOT();
    void VolumeUpSLOT();
    void VolumeDownSLOT();
    void RearVolumeUpSLOT();
    void RearVolumeDownSLOT();
    void FullscreenSLOT();
    void GrabJpgSLOT();
    void GrabPnmSLOT();
    void ConfigurationSLOT();
    void AdjustAspectRatioSlot();
    void RefreshDisplaySlot();
    void CheckClippingTimerSlot();
    void ZapVideoDevSlot();
    void MultiVideoDevSlot();
    void PiPposSlot();
    void PiPzapSlot();
    void PipexchangeSlot();
    void OvlCursorSlot();
#ifdef HAVE_LIBXV
		void XvDeinterlaceSLOT();
		void XvSLOT();
#else
		void XvDeinterlaceSLOT(){};
		void XvSLOT(){};
#endif
    //just all the keys vdr knows about:
    void KeyMenuSLOT(){svdrpc->CmdTKey("Menu");}
    void KeyOkSLOT(){svdrpc->CmdTKey("Ok");}
    void KeyLeftSLOT(){svdrpc->CmdTKey("Left");}
    void KeyRightSLOT(){svdrpc->CmdTKey("Right");}
    void KeyUpSLOT(){svdrpc->CmdTKey("Up");}
    void KeyDownSLOT(){svdrpc->CmdTKey("Down");}
    void KeyBackSLOT(){svdrpc->CmdTKey("Back");}
    void KeyRedSLOT(){svdrpc->CmdTKey("Red");}
    void KeyGreenSLOT(){svdrpc->CmdTKey("Green");}
    void KeyYellowSLOT(){svdrpc->CmdTKey("Yellow");}
    void KeyBlueSLOT(){svdrpc->CmdTKey("Blue");}
    void Key0SLOT(){svdrpc->CmdTKey("0");}
    void Key1SLOT(){svdrpc->CmdTKey("1");}
    void Key2SLOT(){svdrpc->CmdTKey("2");}
    void Key3SLOT(){svdrpc->CmdTKey("3");}
    void Key4SLOT(){svdrpc->CmdTKey("4");}
    void Key5SLOT(){svdrpc->CmdTKey("5");}
    void Key6SLOT(){svdrpc->CmdTKey("6");}
    void Key7SLOT(){svdrpc->CmdTKey("7");}
    void Key8SLOT(){svdrpc->CmdTKey("8");}
    void Key9SLOT(){svdrpc->CmdTKey("9");}
    void RecordSLOT(){svdrpc->CmdTKey("Record");}
#define Num_OSD_Lines 14
    void PgUpSLOT(){for(int i=0;i<Num_OSD_Lines;i++,svdrpc->CmdTKey("Up"));}
    void PgDownSLOT(){for(int i=0;i<Num_OSD_Lines;i++,svdrpc->CmdTKey("Down"),usleep(10000));}
public slots:
    void OverlayOnOffSLOT(int state=0);
};

#endif
