/***************************************************************************
                           main.cpp  -  description
                             -------------------
    begin                : Thu Nov 16 19:12:13 CET 2000
    copyright            : (C) 2000 by guido
    email                : gfiala@s.netic.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define QT_CLEAN_NAMESPACE
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <signal.h>
#include <stdlib.h>

#include "config.h"
#include "kvdr.h"

static const char *description =
	I18N_NOOP("Kvdr");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "b #", I18N_NOOP("X-Server color depth [15|16|24|32]"), 0 },
  { "x"  , I18N_NOOP("force xv-mode on startup and disable overlay-mode"), 0 },
  { "i #", I18N_NOOP("initial de-interlacing-method:0=none 1=50Hz 2=field1"), 0 },
  { "d"  , I18N_NOOP("dont switch modeline during xv"), 0 },
  { "f"  , I18N_NOOP("start up with fullscreen active"), 0 },
  { "a"  , I18N_NOOP("use dvb-audio-control instead of soundcard"), 0 },
  { "u"	 , I18N_NOOP("unmutes the sound on starting up (dvb or sound-card)"),0},
  { "s #", I18N_NOOP("initial number of videoadaptor for PiP [0|1|2|3]"), 0 },
  { "n"	 , I18N_NOOP("deactivate DPMS+screensaver on startup (else only in fullscreen-mode)"),0},  
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

KApplication *akvdr;
Kvdr *kvdr;

void sig_handler(int i)
{
  if(kvdr)delete kvdr;
	akvdr->quit();
	exit(-1);
}

int main(int argc, char *argv[])
{

  KAboutData aboutData( "kvdr", I18N_NOOP("Kvdr"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2003, guido");
  aboutData.addAuthor("guido",0, "gfiala@s.netic.de");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KUniqueApplication a;
  kvdr = new Kvdr();
  a.setMainWidget(kvdr);
  akvdr=&a;
  //kvdr->show();
  //now lets block signals:
  sigset_t newmask,oldmask;
  sigfillset(&newmask);
  sigdelset(&newmask,SIGTERM);
  sigdelset(&newmask,SIGQUIT);
  sigdelset(&newmask,SIGILL);
  sigdelset(&newmask,SIGINT);
//  sigdelset(&newmask,SIGSTOP);
  sigprocmask(0,&newmask,&oldmask);
  struct sigaction act,oldact;
  act.sa_handler=sig_handler;
  if (-1==sigaction(SIGTERM, &act, &oldact)) perror("SIGTERM");
  if (-1==sigaction(SIGQUIT, &act, &oldact)) perror("SIGQUIT");
  if (-1==sigaction(SIGILL , &act, &oldact)) perror("SIGILL");
  if (-1==sigaction(SIGILL , &act, &oldact)) perror("SIGINT");
  int result=a.exec();
  if(kvdr)delete kvdr;
  return result;
}
