// =============================================================================
//
//      --- kvi_treelistdialog_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_treelistdialog_kde.h"

KviTreeListDialog::KviTreeListDialog(QWidget *parent, const char *name, bool modal, const QString &caption, int buttonMask)
	: KDialogBase(TreeList, caption, buttonMask, Ok, parent, name, modal)
{
	setShowIconsInTreeList(true);
}

KviTreeListDialog::~KviTreeListDialog()
{
	// Nothing here
}

void KviTreeListDialog::setButtonHelpText(const QString &text)
{
	setButtonText(Help, text);
}

void KviTreeListDialog::slotHelp()
{
	emit helpClicked();
}

#include "m_kvi_treelistdialog_kde.moc"
