#ifndef _KVI_COLORSELECTOR_H_INCLUDED_
#define _KVI_COLORSELECTOR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_colorselector.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

class KviColorButton;
class KviLabel;

class KviColorSelector : public QWidget
{
	Q_OBJECT
public:
	KviColorSelector(QWidget *parent, const char *label, QColor *valuePtr, bool bEnabled = true, int defInputWidth = 100);
	~KviColorSelector();
private:
	QColor         *m_valuePtr;
	KviLabel       *m_pLabel;
	KviColorButton *m_pClrButton;
	int m_iDefInputWidth;
protected:
	virtual void resizeEvent(QResizeEvent *);
public:
	void setColor(const QColor &clr);
	const QColor getColor();
	virtual QSize sizeHint();
	virtual void setEnabled(bool bEnabled);
public:
	void commitChanges();
};

#endif // _KVI_COLORSELECTOR_H_INCLUDED_
