// =============================================================================
//
//      --- kvi_helpqml.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviHelpQML"

#include "kvi_helpqml.h"
#include "kvi_options.h"

/*
	@quickhelp: nohelpavailable
	@widget: No help available
		There is no help available for the item you have selected.<br>
		Go back to the <a href="index.kvihelp">Main index</a>
*/
KviHelpQML::KviHelpQML(QObject *parent)
	: QStyleSheet(parent)
{
	QStyleSheetItem *style = new QStyleSheetItem(this, "example" );
	style->setFontFamily(g_pOptions->m_fntHelpFixed.family());
	style->setColor(g_pOptions->m_clrHelpExample);
	style->setDisplayMode(QStyleSheetItem::DisplayBlock);
	style->setWhiteSpaceMode(QStyleSheetItem::WhiteSpacePre);
	style->setMargin(QStyleSheetItem::MarginAll, 8);
	style->setFontSize(g_pOptions->m_fntHelpFixed.pointSize());
	style = new QStyleSheetItem(this, "doctitle");
	style->setColor(g_pOptions->m_clrHelpTitle);
	style->setDisplayMode(QStyleSheetItem::DisplayBlock);
	style->setFontFamily(g_pOptions->m_fntHelpNormal.family());
	style->setFontSize(g_pOptions->m_fntHelpNormal.pointSize() + 6);
	style->setFontWeight(QFont::Bold);
	style->setMargin(QStyleSheetItem::MarginVertical, 10);
	style->setMargin(QStyleSheetItem::MarginHorizontal, 0);
	style = new QStyleSheetItem(this, "docsubtitle");
	style->setColor(g_pOptions->m_clrHelpSubtitle);
	style->setDisplayMode(QStyleSheetItem::DisplayBlock);
	style->setFontFamily(g_pOptions->m_fntHelpNormal.family());
	style->setFontSize(g_pOptions->m_fntHelpNormal.pointSize() + 2);
	style->setFontWeight(QFont::Bold);
	style->setMargin(QStyleSheetItem::MarginVertical, 5);
	style->setMargin(QStyleSheetItem::MarginHorizontal, 0);
	style = new QStyleSheetItem(this, "docbody");
	style->setColor(g_pOptions->m_clrHelpFore);
	style->setFontFamily(g_pOptions->m_fntHelpNormal.family());
	style->setFontSize(g_pOptions->m_fntHelpNormal.pointSize());
	style->setDisplayMode(QStyleSheetItem::DisplayBlock);
	style->setMargin(QStyleSheetItem::MarginVertical, 0);
	style->setMargin(QStyleSheetItem::MarginHorizontal, 0);
	style = new QStyleSheetItem(this, "docpre");
	style->setColor(g_pOptions->m_clrHelpFore);
	style->setFontFamily(g_pOptions->m_fntHelpNormal.family());
	style->setFontSize(g_pOptions->m_fntHelpNormal.pointSize());
	style->setDisplayMode(QStyleSheetItem::DisplayBlock);
	style->setMargin(QStyleSheetItem::MarginVertical, 0);
	style->setMargin(QStyleSheetItem::MarginHorizontal, 0);
	style->setWhiteSpaceMode(QStyleSheetItem::WhiteSpacePre);
}

KviHelpQML::~KviHelpQML()
{
	// Nothing here
}

void KviHelpQML::error(const QString &err) const
{
	// Nothing here
}

#include "m_kvi_helpqml.moc"
