// =============================================================================
//
//      --- kvi_imagefiledialog_qt.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviImageFileDialog"

#include "kvi_imagefiledialog_qt.h"
#include "kvi_imagefilepreviewwidget_qt.h"
#include "kvi_locale.h"
#include "kvi_string.h"

KviImageFileDialog::KviImageFileDialog(
	const QString &startFileName, const QString &filter, QWidget *parent, const char *name, bool modal)
	: KviFileDialog(QString::null, filter, parent, name, modal)
{
	setCaption(_CHAR_2_QSTRING(__tr("Select image...")));
	setMode(ExistingOnly);
	KviImageFilePreviewWidget *im = new KviImageFilePreviewWidget(__tr("Preview"), this);
	addRightWidget(im);
	connect(this, SIGNAL(fileHighlighted(const QString &)), im, SLOT(showPreview(const QString &)));
	setSelection(startFileName);
}

KviImageFileDialog::~KviImageFileDialog()
{
	// Nothing here
}

#include "m_kvi_imagefiledialog_qt.moc"
