// =============================================================================
//
//      --- kvi_fileselector.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviFileSelector"

#include <qframe.h>
#include <qlayout.h>

#include "kvi_filedialog.h"
#include "kvi_fileselector.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_messagebox.h"
#include "kvi_pushbutton.h"
#include "kvi_string.h"

KviFileSelector::KviFileSelector(QWidget *parent, KviStr *valuePtr, bool bMustBeReadable, bool bEnabled)
	: QWidget(parent)
{
	QGridLayout *g    = new QGridLayout(this, 1, 2, 0, 2);
	m_valuePtr        = valuePtr;
	m_bMustBeReadable = bMustBeReadable;
	m_pButton         = new KviPushButton(_CHAR_2_QSTRING(__tr("&Browse...")), this);
	m_pValueLabel     = new KviLabel(valuePtr->ptr(), this);
	m_pValueLabel->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	g->addWidget(m_pValueLabel, 0, 0);
	g->addWidget(m_pButton, 0, 1);
	connect(m_pButton, SIGNAL(clicked()), this, SLOT(changeFile()));
	setMinimumSize(sizeHint());
	setEnabled(bEnabled);
}

KviFileSelector::~KviFileSelector()
{
	// Nothing here
}

QSize KviFileSelector::sizeHint()
{
	QSize sz = m_pValueLabel->sizeHint();
	sz.setWidth(sz.width() + m_pButton->sizeHint().width() + 4);
	return sz;
}

void KviFileSelector::commitChanges()
{
	*m_valuePtr = m_pValueLabel->text();
}

void KviFileSelector::changeFile()
{
	QString s = KviFileDialog::getOpenFileName(m_pValueLabel->text(), QString::null, this);
	if( !s.isNull() ) {
		if( m_bMustBeReadable ) {
			QFileInfo fi(s);
			if( !(fi.exists() && fi.isFile() && fi.isReadable()) ) {
				KviStr tmp(KviStr::Format, __tr("The file %s is not readable."), s.latin1());
				KviMessageBox::error(_CHAR_2_QSTRING(tmp.ptr()), _CHAR_2_QSTRING(__tr("KVIrc: File Selector")));
				return;
			}
		}
		m_pValueLabel->setText(s);
	}
}

void KviFileSelector::setEnabled(bool bEnabled)
{
	m_pValueLabel->setEnabled(bEnabled);
	m_pButton->setEnabled(bEnabled);
	QWidget::setEnabled(bEnabled);
}

#include "m_kvi_fileselector.moc"
