// =============================================================================
//
//      --- kvi_options_defaultmessages.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsDefaultMessages"

#include <qlayout.h>

#include "kvi_locale.h"
#include "kvi_options_defaultmessages.h"
#include "kvi_options.h"
#include "kvi_stringselector.h"

/*
	@quickhelp: KviOptionsDefaultMessages
	@widget: Default messages
		Here you can set the default text strings that will be sent to the server
		when you specify no replacement.<br>
		The "PART reason" is the additional text automatically sent to the server
		when you close a channel window.<br>
		The other users on the channel will see something like:<br>
		&lt;Yournick&gt; has left #channel (&lt;reason&gt;).<br>
		You can override this setting by sending manually the <a href="part.kvihelp">/PART</a> message.<br>
		The "KICK reason" is the default reason for the <a href="kick.kvihelp">/KICK</a> command.<br>
		It is used when no other reason is specified.<br>
		The "QUIT reason" is the additional text automatically sent to the server
		when you terminate an IRC connection by pressing the "Disconnect" button
		on the toolbar or selecting "Disconnect" from the menu.<br>
		You can override this setting by sending manually the <a href="quit.kvihelp">/QUIT</a> message.<br>
*/
KviOptionsDefaultMessages::KviOptionsDefaultMessages(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_DEFAULTMESSAGES)
{
	QGridLayout *g = new QGridLayout(
		this, 4, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviStringSelector *s = new KviStringSelector(this, __tr("Part reason:"), &(g_pOptions->m_szPartMessage));
	g->addWidget(s, 0, 0);
	s = new KviStringSelector(this, __tr("Kick reason:"), &(g_pOptions->m_szKickMessage));
	g->addWidget(s, 1, 0);
	s = new KviStringSelector(this, __tr("Quit reason:"), &(g_pOptions->m_szQuitMessage));
	g->addWidget(s, 2, 0);

	// Trick
	QFrame *f = new QFrame(this);
	g->addWidget(f, 3, 0);
	g->setRowStretch(3, 1);
}

KviOptionsDefaultMessages::~KviOptionsDefaultMessages()
{
	// Nothing here
}

void KviOptionsDefaultMessages::commitChanges()
{
	KviStringSelector::commitAll(this);
}

#include "m_kvi_options_defaultmessages.moc"
