// =============================================================================
//
//      --- kvi_options_dirbrowser.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsDirBrowser"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_boolselector.h"
#include "kvi_locale.h"
#include "kvi_options_dirbrowser.h"
#include "kvi_options.h"
#include "kvi_stringselector.h"

/*
	@quickhelp: KviOptionsDirBrowser
	@widget: Directory browser options
		Here you can setup the directory browser behaviour.<br>
		You can decide to show or not the hidden (dot) files.<br>
		There are three rather self-explaining options that control the sorting of items inside
		the browser.<br>
		The "Open with editor" command is the KVIrc script command to be executed
		when you select "Open with editor" from the borwser context sensitive popup menu.<br>
		Usually it will be something as "run myeditor <a href="s_execfilename.kvihelp">$ExecFilename</a>".<br>
*/
KviOptionsDirBrowser::KviOptionsDirBrowser(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_DIRBROWSER)
{
	QGridLayout *g = new QGridLayout(
		this, 9, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Show hidden files"), &(g_pOptions->m_bDirBrowserShowHiddenFiles)
	);
	g->addWidget(b, 0, 0);
	b = new KviBoolSelector(this, __tr("Group files by extension"), &(g_pOptions->m_bDirBrowserGroupFilesByExtension));
	g->addWidget(b, 1, 0);
	b = new KviBoolSelector(this, __tr("Sort by size"), &(g_pOptions->m_bDirBrowserSortBySize));
	g->addWidget(b, 2, 0);
	b = new KviBoolSelector(this, __tr("Case insensitive sorting"), &(g_pOptions->m_bDirBrowserSortCaseInsensitive));
	g->addWidget(b, 3, 0);
	KviStringSelector *s = new KviStringSelector(this,
		__tr("\"Open with editor\" command ($ExecFileName = filename):"),
		&(g_pOptions->m_szDirBrowserOpenWithEditorCmd), true, 180
	);
	g->addWidget(s, 4, 0);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 5, 0);

	KviBoolSelector *b1 = new KviBoolSelector(this,
		__tr("Open as MDI window"), &(g_pOptions->m_bDirBrowserOpenAsMdiWindow)
	);
	g->addWidget(b1, 6, 0);
	b = new KviBoolSelector(this,
		__tr("Open as undocked MDI window"),
		&(g_pOptions->m_bDirBrowserOpenAlwaysUndocked), g_pOptions->m_bDirBrowserOpenAsMdiWindow
	);
	connect(b1, SIGNAL(toggled(bool)), b, SLOT(setEnabled(bool)));
	g->addWidget(b, 7, 0);

	// Trick
	f = new QFrame(this);
	g->addWidget(f, 8, 0);
	g->setRowStretch(8, 1);
}

KviOptionsDirBrowser::~KviOptionsDirBrowser()
{
	// Nothing here
}

void KviOptionsDirBrowser::commitChanges()
{
	KviBoolSelector::commitAll(this);
	KviStringSelector::commitAll(this);
	g_pApp->updateAllDirectoryBrowsers();
}

#include "m_kvi_options_dirbrowser.moc"
