// =============================================================================
//
//      --- kvi_options_gui_global.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiGlobal"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_boolselector.h"
#include "kvi_colorselector.h"
#include "kvi_combobox.h"
#include "kvi_fontselector.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_options_gui_global.h"
#include "kvi_options.h"
#include "kvi_string.h"

/*
	@quickhelp: KviOptionsGuiGlobal
	@widget: Global GUI options
*/
KviOptionsGuiGlobal::KviOptionsGuiGlobal(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIGLOBAL)
{
	QGridLayout *g = new QGridLayout(this, 13, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviFontSelector *f = new KviFontSelector(this, __tr("Global application font:"), &(g_pOptions->m_fntApplication));
	g->addMultiCellWidget(f, 0, 0, 0, 1);

	QFrame *r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(r, 1, 1, 0, 1);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Use private global color palette"), &(g_pOptions->m_bSetGlobalPaletteAtStartup));
	g->addMultiCellWidget(b, 2, 2, 0, 1);

	KviColorSelector *s = new KviColorSelector(this, __tr("Foreground:"), &(g_pOptions->m_clrNormalGlobalForeground));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 3, 0);
	s = new KviColorSelector(this, __tr("Background:"), &(g_pOptions->m_clrNormalGlobalButton));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 4, 0);
	s = new KviColorSelector(this, __tr("Light shadow:"), &(g_pOptions->m_clrNormalGlobalLight));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 5, 0);
	s = new KviColorSelector(this, __tr("Middle shadow:"), &(g_pOptions->m_clrNormalGlobalMid));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 6, 0);
	s = new KviColorSelector(this, __tr("Dark shadow:"), &(g_pOptions->m_clrNormalGlobalDark));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 7, 0);
	s = new KviColorSelector(this, __tr("Text:"), &(g_pOptions->m_clrNormalGlobalText));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 3, 1);
	s = new KviColorSelector(this, __tr("Base:"), &(g_pOptions->m_clrNormalGlobalBase));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 4, 1);
	s = new KviColorSelector(this, __tr("Disabled foreground:"), &(g_pOptions->m_clrDisabledGlobalForeground));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 5, 1);
	s = new KviColorSelector(this, __tr("Disabled text:"), &(g_pOptions->m_clrDisabledGlobalText));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 6, 1);
	s = new KviColorSelector(this, __tr("Disabled base:"), &(g_pOptions->m_clrDisabledGlobalBase));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addWidget(s, 7, 1);

	KviLabel *l = new KviLabel(_CHAR_2_QSTRING(__tr("Application GUI style:")), this);
	g->addWidget(l, 8, 0);

	m_pGUIStyleBox = new KviComboBox(false, this);
	g->addWidget(m_pGUIStyleBox, 8, 1);

	r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(r, 9, 9, 0, 1);

	b = new KviBoolSelector(this, __tr("Use large main toolbar images"), &(g_pOptions->m_bUseBigToolbarPixmaps));
	g->addWidget(b, 10, 0);
	b = new KviBoolSelector(this, __tr("Use large user toolbar images"), &(g_pOptions->m_bUseBigUserToolbarPixmaps));
	g->addWidget(b, 11, 0);
	b = new KviBoolSelector(this, __tr("Show text under toolbar icons"), &(g_pOptions->m_bUseTextToolbarComment));
	g->addWidget(b, 10, 1);
	b = new KviBoolSelector(this, __tr("Use KDE theme background for menubar"), &(g_pOptions->m_bUseThemeMenubarBackground));
	g->addWidget(b, 11, 1);

	r = new QFrame(this);
	g->addMultiCellWidget(r, 12, 12, 0, 1);
	g->setRowStretch(12, 1);

	fillGuiStylesBox();
}

KviOptionsGuiGlobal::~KviOptionsGuiGlobal()
{
	// Nothing here
}

void KviOptionsGuiGlobal::fillGuiStylesBox()
{
	int idx = 1;
	int currentStyle = -1;
	m_pGUIStyleBox->insertItem("default");
	if( kvi_strEqualCI("default", g_pOptions->m_szApplicationGUIStyle.ptr()) )
		currentStyle = 0;
	for( KviStyleEntry *e = g_pApp->m_pStyleList->first(); e; e = g_pApp->m_pStyleList->next() ) {
		m_pGUIStyleBox->insertItem(_CHAR_2_QSTRING(e->name.ptr()));
		if( kvi_strEqualCI(e->name.ptr(), g_pOptions->m_szApplicationGUIStyle.ptr()) )
			currentStyle = idx;
		idx++;
	}
	if( currentStyle != -1 )
		m_pGUIStyleBox->setCurrentItem(currentStyle);
}

void KviOptionsGuiGlobal::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	KviBoolSelector::commitAll(this);

	KviStr save = g_pOptions->m_szApplicationGUIStyle;
	g_pOptions->m_szApplicationGUIStyle = m_pGUIStyleBox->currentText();
	if( g_pOptions->m_szApplicationGUIStyle.isEmpty() ) {
		g_pOptions->m_szApplicationGUIStyle = save;
	}

	if( g_pApp->font() != g_pOptions->m_fntApplication ) {
		// Somehow if we let KviApplication set the font for
		// any QWidget descendant, a crash occurs. So, we pick
		// only those classes we wish to see updated here
		g_pApp->setFont(g_pOptions->m_fntApplication, true, "KviFrame");
		g_pApp->setFont(g_pOptions->m_fntApplication, true, "KviMenuBar");
		g_pApp->setFont(g_pOptions->m_fntApplication, true, "KviToolBar");
	}
	if( g_pOptions->m_bSetGlobalPaletteAtStartup ) {
		QColorGroup cg(
			g_pOptions->m_clrNormalGlobalForeground,
			g_pOptions->m_clrNormalGlobalButton,
			g_pOptions->m_clrNormalGlobalLight,
			g_pOptions->m_clrNormalGlobalDark,
			g_pOptions->m_clrNormalGlobalMid,
			g_pOptions->m_clrNormalGlobalText,
			g_pOptions->m_clrNormalGlobalText.light(150),
			g_pOptions->m_clrNormalGlobalBase,
			g_pOptions->m_clrNormalGlobalButton
		);
		QColorGroup cgdis(
			g_pOptions->m_clrDisabledGlobalForeground,
			g_pOptions->m_clrNormalGlobalButton,
			g_pOptions->m_clrNormalGlobalLight,
			g_pOptions->m_clrNormalGlobalDark,
			g_pOptions->m_clrNormalGlobalMid,
			g_pOptions->m_clrDisabledGlobalText,
			g_pOptions->m_clrNormalGlobalText.light(150),
			g_pOptions->m_clrDisabledGlobalBase,
			g_pOptions->m_clrNormalGlobalButton
		);
		QPalette pal(cg, cgdis, cg);
		g_pApp->setPalette(pal, true); // Repaint widgets this time
	} else {
		if( g_pApp->palette() != g_pApp->m_savedAppPalette )
			g_pApp->setPalette(g_pApp->m_savedAppPalette, true);
	}
	g_pApp->setApplicationStyle();
	g_pApp->triggerGlobalRepaint();
}

#include "m_kvi_options_gui_global.moc"
