// =============================================================================
//
//      --- kvi_options_gui_listbox.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiListBox"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_boolselector.h"
#include "kvi_colorselector.h"
#include "kvi_fontselector.h"
#include "kvi_imageselector.h"
#include "kvi_locale.h"
#include "kvi_options_gui_listbox.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsGuiListBox
	@widget: Channel userlist GUI options
*/
KviOptionsGuiListBox::KviOptionsGuiListBox(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUILISTBOX)
{
	QGridLayout *g = new QGridLayout(this, 12, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviColorSelector *s = new KviColorSelector(this, __tr("Background color:"), &(g_pOptions->m_clrListBoxBack));
	g->addWidget(s, 0, 0);
	s = new KviColorSelector(this, __tr("Owner foreground color:"), &(g_pOptions->m_clrListBoxOwner));
	g->addWidget(s, 1, 0);
	s = new KviColorSelector(this, __tr("Op foreground color:"), &(g_pOptions->m_clrListBoxOp));
	g->addWidget(s, 2, 0);
	s = new KviColorSelector(this, __tr("Halfop foreground color:"), &(g_pOptions->m_clrListBoxHalfOp));
	g->addWidget(s, 3, 0);
	s = new KviColorSelector(this, __tr("Voice foreground color:"), &(g_pOptions->m_clrListBoxVoice));
	g->addWidget(s, 4, 0);
	s = new KviColorSelector(this, __tr("Userop foreground color:"), &(g_pOptions->m_clrListBoxUserOp));
	g->addWidget(s, 5, 0);
	s = new KviColorSelector(this, __tr("Normal foreground color:"), &(g_pOptions->m_clrListBoxNormal));
	g->addWidget(s, 6, 0);
	s = new KviColorSelector(this, __tr("Selection background color:"), &(g_pOptions->m_clrListBoxSeleBack));
	g->addWidget(s, 7, 0);
	s = new KviColorSelector(this, __tr("Selection foreground color:"), &(g_pOptions->m_clrListBoxSeleFore));
	g->addWidget(s, 8, 0);
	KviFontSelector *f = new KviFontSelector(this, __tr("Font:"), &(g_pOptions->m_fntListBox));
	g->addWidget(f, 9, 0);
	// Separator
	QFrame *fr = new QFrame(this);
	fr->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(fr, 10, 0);

	m_pListBoxImageSelector = new KviImageSelector(this,
		__tr("Use background image:"), &(g_pOptions->m_szListBoxBack), g_pOptions->m_pixListBoxBack
	);
	g->addWidget(m_pListBoxImageSelector, 11, 0);
	// Separator
	fr = new QFrame(this);
	fr->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(fr, 12, 0);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Show owner, op, halfop, voice, and userop icons"), &(g_pOptions->m_bListBoxShowImages)
	);
	g->addWidget(b, 13, 0);

	fr = new QFrame(this);
	g->addWidget(fr, 14, 0);
	g->setRowStretch(14, 1);
}

KviOptionsGuiListBox::~KviOptionsGuiListBox()
{
	// Nothing here
}

void KviOptionsGuiListBox::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	KviBoolSelector::commitAll(this);
	g_pOptions->calculateListBoxFontVariables();
	g_pOptions->loadListBoxBackgroundImage(m_pListBoxImageSelector->getImage());
	g_pApp->triggerGlobalRepaint();
}

#include "m_kvi_options_gui_listbox.moc"
