// =============================================================================
//
//      --- kvi_options_gui_mirccolors.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiMircColors"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_colorselector.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_options_gui_mirccolors.h"
#include "kvi_options.h"
#include "kvi_pushbutton.h"
#include "kvi_string.h"

// Declared in kvi_options.cpp
extern QRgb defaultMircRgb[16];

/*
	@quickhelp: KviOptionsGuiMircColors
	@widget: Help browser GUI options
*/
KviOptionsGuiMircColors::KviOptionsGuiMircColors(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMIRCCOLORS)
{
	QGridLayout *g = new QGridLayout(this, 8, 4, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Use KSirc control codes"), &(g_pOptions->m_bUseKsircControlCodes)
	);
	g->addMultiCellWidget(b, 0, 0, 0, 3);
	KviLabel *l = new KviLabel(_CHAR_2_QSTRING(__tr("mIRC/KSirc colors:")), this);
	g->addMultiCellWidget(l, 1, 1, 0, 3);
	KviStr szNum;
	for( int i = 0; i < 16; i++ ) {
		szNum.setNum(i);
		m_pMircColorSelector[i] = new KviColorSelector(this, szNum.ptr(), g_pOptions->m_pMircColor[i], true, 50);
		g->addWidget(m_pMircColorSelector[i], (i / 4) + 2, i % 4);
	}
	KviPushButton *pb = new KviPushButton(__tr("&Reset"), this);
	g->addWidget(pb, 6, 0);
	connect(pb, SIGNAL(clicked()), this, SLOT(resetToMircColors()));

	pb = new KviPushButton(__tr("&Invert"), this);
	g->addWidget(pb, 6, 1);
	connect(pb, SIGNAL(clicked()), this, SLOT(invertColors()));

	pb = new KviPushButton(__tr("20% &Darker"), this);
	g->addWidget(pb, 6, 2);
	connect(pb, SIGNAL(clicked()), this, SLOT(makeDarker()));

	pb = new KviPushButton(__tr("20% &Lighter"), this);
	g->addWidget(pb, 6, 3);
	connect(pb, SIGNAL(clicked()), this, SLOT(makeLighter()));

	QFrame *fr = new QFrame(this);
	g->addMultiCellWidget(fr, 7, 7, 0, 3);
	g->setRowStretch(7, 1);
}

KviOptionsGuiMircColors::~KviOptionsGuiMircColors()
{
	// Nothing here
}

void KviOptionsGuiMircColors::commitChanges()
{
	KviBoolSelector::commitAll(this);
	commitColorSelectors();
}

void KviOptionsGuiMircColors::resetToMircColors()
{
	for( int i = 0; i < 16; i++ )
		m_pMircColorSelector[i]->setColor(QColor(defaultMircRgb[i]));
}

void KviOptionsGuiMircColors::invertColors()
{
	for( int i = 0; i < 16; i++ ) {
		QColor clr(m_pMircColorSelector[i]->getColor());
		clr.setRgb(255 - clr.red(), 255 - clr.green(), 255 - clr.blue());
		m_pMircColorSelector[i]->setColor(clr);
	}
}

void KviOptionsGuiMircColors::makeDarker()
{
	for( int i = 0; i < 16; i++ ) {
		m_pMircColorSelector[i]->setColor(m_pMircColorSelector[i]->getColor().dark(120));
	}
}

void KviOptionsGuiMircColors::makeLighter()
{
	for( int i = 0; i < 16; i++ ) {
		m_pMircColorSelector[i]->setColor(m_pMircColorSelector[i]->getColor().light(120));
	}
}

#include "m_kvi_options_gui_mirccolors.moc"
