// =============================================================================
//
//      --- kvi_systray_ioled.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviSysTrayIoLed"

#include <qpainter.h>
#include <qpixmap.h>

#include "kvi_locale.h"
#include "kvi_systray.h"
#include "kvi_systray_ioled.h"

KviSysTrayIoLed::KviSysTrayIoLed(KviSysTray *parent)
	: KviSysTrayWidget(parent, __tr("I/O Meter\nUpper bar: input packets\nLower bar: output packets"), "systray_io_led")
{
	m_timer   = 0;
	m_iOutLed = 0;
	m_iInLed  = 0;
	setBackgroundMode(NoBackground);
}

KviSysTrayIoLed::~KviSysTrayIoLed()
{
	if( m_timer )
		killTimer(m_timer);
}

QString KviSysTrayIoLed::icon()
{
	return SYSTRAY_ICON_IO_LED;
}

void KviSysTrayIoLed::show()
{
	m_timer = startTimer(1000);
	KviSysTrayWidget::show();
}

void KviSysTrayIoLed::hide()
{
	if( m_timer ) {
		killTimer(m_timer);
		m_timer   = 0;
		m_iOutLed = 0;
		m_iInLed  = 0;
	}
	KviSysTrayWidget::hide();
}

void KviSysTrayIoLed::clear()
{
	m_iOutLed = 0;
	m_iInLed  = 0;
	update();
}

void KviSysTrayIoLed::timerEvent(QTimerEvent *e)
{
	if( e->timerId() == m_timer ) {
		if( m_iInLed | m_iOutLed ) {
			if( m_iInLed  > 0 ) m_iInLed--;
			if( m_iOutLed > 0 ) m_iOutLed--;
			paintEvent(0);
		}
	}
}

void KviSysTrayIoLed::dataMessageReceived()
{
	if( !isVisible() )
		return;
	m_iInLed++;
	paintEvent(0);
}

void KviSysTrayIoLed::dataMessageSent()
{
	if( !isVisible() )
		return;
	m_iOutLed += 2;
	paintEvent(0);
}

void KviSysTrayIoLed::paintEvent(QPaintEvent *)
{
	if( !isVisible() )
		return;

	QPainter pa(m_pSysTray->getMemoryBuffer());
	int widgetWidth  = width();
	int widgetHeight = height();

	paintDefaultBackground(&pa);

	int hght = (widgetHeight - 12) >> 1;
	if( m_iInLed > 0 ) {
		pa.setPen(QPen(Qt::green, 4));
		for( int i = 0; i < m_iInLed; i++ ) {
			if( i == 10 )
				pa.setPen(QPen(Qt::yellow, 4));
			else if( i == 20 )
				pa.setPen(QPen(Qt::red, 4));
			int x1 = 4 + (i * 5);
			if( x1 > widgetWidth ) {
				m_iInLed = i; // Stop increasing
				break;
			}
			pa.drawLine(x1, 4, x1, 4 + hght);
		}
	}

	int y1 = hght + 8;
	if( m_iOutLed > 0 ) {
		pa.setPen(QPen(Qt::green, 4));
		for( int i = 0; i < m_iOutLed; i++ ) {
			if( i == 10 )
				pa.setPen(QPen(Qt::yellow, 4));
			else if( i == 20 )
				pa.setPen(QPen(Qt::red, 4));
			int x1 = 4 + (i * 5);
			if( x1 > widgetWidth )
				break;
			pa.drawLine(x1, y1, x1, y1 + hght);
		}
	}

	paintDefaultFrame(&pa);

	bitBlt(this, 0, 0, m_pSysTray->getMemoryBuffer(), 0, 0, widgetWidth, widgetHeight);
}

#include "m_kvi_systray_ioled.moc"
