// =============================================================================
//
//      --- kvi_biff_configdialog.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Authors:
//       Krzysztof Godlewski    <kristoff@poczta.wprost.pl>
//       Szymon Stefanek        <stefanek@tin.it>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviBiffConfigDialogDialog"

#include <qtabbar.h>
#include <qvbox.h>

#include "kvi_biff.h"
#include "kvi_biff_configdialog.h"
#include "kvi_biff_mailbox.h"
#include "kvi_label.h"
#include "kvi_listview.h"
#include "kvi_locale.h"
#include "kvi_messagebox.h"
#include "kvi_pushbutton.h"

extern KviBiff *g_pBiff;

KviBiffConfigDialog::KviBiffConfigDialog()
	: KviTabDialog(0, "BiffConfigDialog", false)
{
	setCaption(__tr("Biff plugin configuration"));

	// "General" tab
	QVBox *vb = addVBoxPage(_CHAR_2_QSTRING(__tr("General")));
	vb->setMargin(5);

	KviLabel *lab = new KviLabel(vb);
	lab->setAlignment(AlignCenter);
	lab->setText(_CHAR_2_QSTRING("Nothing here yet ! :)"));
	//
	// TODO: Some options here, like: Auto check all, auto check interval etc...
	//

	// "Mailboxes" tab
	vb = addVBoxPage(_CHAR_2_QSTRING(__tr("Mailboxes")));
	m_mailboxPage = vb;
	vb->setMargin(5);
	m_mboxView = new KviListView(vb, "mailboxes", true);

	const char *columns[] =
	{
		__tr("Login"),
		__tr("Server"),
		__tr("Port"),
		__tr("Password"),
		__tr("Check")
	};

#define Col_Login          0
#define Col_Server         1
#define Col_Port           2
#define Col_Password       3
#define Col_Check          4

	for( uint i = 0; i < sizeof(columns) / sizeof(columns[0]); i++ )
	    m_mboxView->addColumn(_CHAR_2_QSTRING(columns[i]));

	m_mboxView->setShowSortIndicator(true);

	QHBox *hb = new QHBox(vb);
	hb->setMargin(5);

	KviPushButton *b;
	b = new KviPushButton(_CHAR_2_QSTRING(__tr("Add")), hb);
	b->setFocus();
	connect(b, SIGNAL(clicked()), SLOT(slotAddMailbox()));

	b = new KviPushButton(_CHAR_2_QSTRING(__tr("Remove")), hb);
	connect(b, SIGNAL(clicked()), SLOT(slotRemoveMailbox()));

	b = new KviPushButton(_CHAR_2_QSTRING(__tr("Remove all")), hb);
	connect(b, SIGNAL(clicked()), SLOT(slotRemoveAll()));
}

KviBiffConfigDialog::~KviBiffConfigDialog()
{
	// Nothing here
}

void KviBiffConfigDialog::setOptions()
{
	// TODO: do something with g_pBiff->configStruct() here
	m_mboxView->clear();
	QPtrList<KviBiffMailbox> *const mbl = g_pBiff->mailboxList();

	for( KviBiffMailbox *mb = mbl->first(); mb; mb = mbl->next() ) {
	    KviListViewItem *vi = new KviListViewItem(m_mboxView);
	    QString s;
	    s.setNum(mb->port());
	    vi->setText(Col_Login,    mb->username());
	    vi->setText(Col_Server,   mb->hostname());
	    vi->setText(Col_Port,     s);
	    vi->setText(Col_Password, mb->password());
	    vi->setText(Col_Check,    mb->autoCheck() ? "true" : "false");
	}
}

void KviBiffConfigDialog::getOptions()
{
	// TODO: Set correct options to g_pBiff->configStruct() here
	if( g_pBiff->mailboxList()->count() )
	    g_pBiff->mailboxList()->clear();

	for( KviListViewItem *i = m_mboxView->firstChild(); i; i = i->itemBelow() ) {
	    KviBiffMailbox *mb = new KviBiffMailbox(
	        i->text(Col_Server).latin1(),
	        i->text(Col_Login).latin1(),
	        i->text(Col_Password).latin1(),
	        i->text(Col_Port).toUInt(),
	        kvi_strEqualCI(i->text(Col_Check).latin1(), "true")
		);

	    if( mb ) g_pBiff->mailboxList()->append(mb);
	}
}

void KviBiffConfigDialog::slotAddMailbox()
{
	KviListViewItem *i = new KviListViewItem(m_mboxView);
	i->setText(Col_Login,    "-x-");
	i->setText(Col_Server,   "-x-");
	i->setText(Col_Port,     "110");
	i->setText(Col_Password, "-x-");
	i->setText(Col_Check,    "true");

	m_mboxView->insertItem(i);
	m_mboxView->triggerUpdate();
}

void KviBiffConfigDialog::slotRemoveMailbox()
{
	if( !m_mboxView->selectedItem() ) return;

	const KviBiffMailbox *mb = g_pBiff->findMailbox(
		m_mboxView->selectedItem()->text(Col_Login).latin1(),
	    m_mboxView->selectedItem()->text(Col_Server).latin1());

	if( mb ) {
	    if( KviMessageBox::warningYesNo(
	        _CHAR_2_QSTRING(__tr("Are you sure you want to remove this mailbox from the list?")),
			_CHAR_2_QSTRING(__tr("Remove Mailbox"))) == KviMessageBox::Yes
		) {
	        g_pBiff->mailboxList()->removeRef(mb);
	        m_mboxView->removeItem(m_mboxView->selectedItem());
	    }
	}
	else
	    m_mboxView->removeItem(m_mboxView->selectedItem());
}

void KviBiffConfigDialog::slotRemoveAll()
{
	if( KviMessageBox::warningYesNo(
	    _CHAR_2_QSTRING(__tr("Are you sure you want to remove all mailboxes from the list?")),
		_CHAR_2_QSTRING(__tr("Remove Mailbox"))) == KviMessageBox::Yes
	) {
	    g_pBiff->mailboxList()->clear();
	    m_mboxView->clear();
	}
}

void KviBiffConfigDialog::activateMailboxesTab()
{
	showPageForWidget(m_mailboxPage);
}

#include "m_kvi_biff_configdialog.moc"
