#ifndef _KVI_KVS_ARRAY_H_
#define _KVI_KVS_ARRAY_H_
//=============================================================================
//
//	File : kvi_kvs_array.h
//	Created on Tue 07 Oct 2003 01:07:31 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"

#include <qintdict.h>

#include "kvi_qstring.h"

#include "kvi_kvs_variant.h"

class KVIRC_API KviKvsArray
{
public:
	KviKvsArray();
	KviKvsArray(const KviKvsArray &a);
	~KviKvsArray();
protected:
	QIntDict<KviKvsVariant> * m_pDict;
public:
	void unset(int iIdx){ m_pDict->remove(iIdx); };
	void set(int iIdx,KviKvsVariant * pVal){ m_pDict->replace(iIdx,pVal); };
	KviKvsVariant * find(int iIdx) const { return m_pDict->find(iIdx); };
	KviKvsVariant * get(int iIdx);

	bool isEmpty() const { return m_pDict->isEmpty(); };
	unsigned int size() const;
	
	unsigned int count() const { return m_pDict->count(); };
	
	void appendAsString(QString &szBuffer) const;
};

#endif //!_KVI_KVS_ARRAY_H_
