//=============================================================================
//
//   File : kvi_kvs_corefunctions.cpp
//   Created on Fri 31 Oct 2003 01:52:04 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_corefunctions.h"

#include "kvi_kvs_kernel.h"

namespace KviKvsCoreFunctions
{
	void init()
	{
		KviKvsKernel * pKern = KviKvsKernel::instance();

#define _REGFNC(__fncName,__routine) \
		{ \
			KviKvsCoreFunctionExecRoutine * r = new KviKvsCoreFunctionExecRoutine; \
			r->proc = KVI_PTR2MEMBER(KviKvsCoreFunctions::__routine); \
			pKern->registerCoreFunctionExecRoutine(QString(__fncName),r); \
		}
		
		// a_f
		_REGFNC("array",array)
		// g_l
		_REGFNC("hash",hash);
		_REGFNC("isEmpty",isEmpty)
		_REGFNC("isNumeric",isNumeric)
		_REGFNC("isSet",isSet)
		_REGFNC("isTimer",isTimer)

		_REGFNC("keys",keys)

		// m_r

		// s_z
		_REGFNC("sw",sw)
		_REGFNC("window",window)

#undef _REGCMD
	}
};

