//=============================================================================
//
//   File : kvi_kvs_corefunctions_af.cpp
//   Created on Fri 31 Oct 2003 01:52:04 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_corefunctions.h"

#include "kvi_kvs_kernel.h"

#include "kvi_locale.h"

namespace KviKvsCoreFunctions
{
	///////////////////////////////////////////////////////////////////////////////////////////////

	/*
		@doc: array
		@type:
			function
		@title:
			$array
		@short:
			Explicitly creates an array
		@syntax:
			$array(<item>,<item>,<item>,....);
		@description:
			Returns an array with the specified items. The items are indexed starting from 0.
			This is just an explicit way of creating an array with a defined set of items,
			useful for increasing readability. 
		@examples:
			[cmd]alias[/cmd](test){ [cmd]return[/cmd] $array(1,2,3); };
			%x = $test();
			[cmd]foreach[/cmd](%y,%x)
			{
				[cmd]echo[/cmd] %y;
			}
		@seealso:
			[fnc]$hash[/fnc]
	*/

	_KVS_COREFUNCTION(array)
	{
		KviKvsArray * a = new KviKvsArray();
		int idx = 0;
		
		for(KviKvsVariant * v = pParams->first();v;v = pParams->next())
		{
			a->set(idx,new KviKvsVariant(*v));
			idx++;
		}
		
		pRetBuffer->setArray(a);
		return true;
	}
};

