//=============================================================================
//
//   File : kvi_kvs_coresimplecommands.cpp
//   Created on Fri 31 Oct 2003 00:04:25 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_coresimplecommands.h"

#include "kvi_kvs_kernel.h"

namespace KviKvsCoreSimpleCommands
{
	void init()
	{
		KviKvsKernel * pKern = KviKvsKernel::instance();

#define _REGCMD(__cmdName,__routine) \
		{ \
			KviKvsCoreSimpleCommandExecRoutine * r = new KviKvsCoreSimpleCommandExecRoutine; \
			r->proc = KVI_PTR2MEMBER(KviKvsCoreSimpleCommands::__routine); \
			pKern->registerCoreSimpleCommandExecRoutine(QString(__cmdName),r); \
		}

/*
	"HOST"        , "QUERY"       , "RAW"         , "QUOTE"       , //<--4
	"NICK"        , "PRIVMSG"     , "MSG"         , "NOTICE"      , "JOIN"        , //<--9
	"PART"        , "LEAVE"       , "TOPIC"       , "OP"          , "DEOP"        , //<--14
	"VOICE"       , "DEVOICE"     , "MODE"        , "DELETE"      , "DESTROY"     , //<--19
	"CLASS"       , "PRIVATEIMPL" , "SETRETURN"
	"SRAND"       , "SERVER"      , "CONNECT"     , "DISCONNECT"
	"EVENT"       , "EVENTCTL"    , "BAN"         , "UNBAN"       , //<--34
	"ME"          , "CTCP"
	"AVATAR"      , "AWHOIS"      , "OPTION"      ,
	"KICK"        , "WHO"         , "OPER"        , "SERVICE"     , "SQUIT"       , //<--49
	"LIST"        , "INVITE"      , "MOTD"        , "LUSERS"      , "VERSION"     , //<--54
	"STATS"       , "LINKS"       , "TIME"        , "TRACE"       , "ADMIN"       , //<--59
	"INFO"        , "SQUERY"      , "AWAY"        , "BACK"        , "RUN"         , //<--64
	"PLAY"        , "QUIT"        , "OPENURL"     , "HELP"
	"RAISE"       , "ADDTARGET"   , "DELTARGET"   , //<--74
	"BUTTON"      , "CLEAR"       , "BUTTONCTL"   , //<--79
	"SOUND"       , "PASS"        , "SETMENU"     , "BEEP"
	"CLEAROBJECTS", "EVAL"        , "SAY"
*/

		// a_f
		_REGCMD("echo",echo)
		// g_l
		_REGCMD("halt",halt)
		_REGCMD("killtimer",killtimer)
		// m_r
		_REGCMD("parse",parse)
		_REGCMD("popup",popup)
		_REGCMD("return",return_CKEYWORDWORKAROUND);
		_REGCMD("rebind",rebind)
		// s_z
		_REGCMD("whois",whois)
		_REGCMD("whowas",whowas)

#undef _REGCMD
	}
};

