#ifndef _KVI_KVS_REPORTTARGET_H_
#define _KVI_KVS_REPORTTARGET_H_
//=============================================================================
//
//   File : kvi_kvs_reporttarget.h
//   Created on Wed 29 Oct 2003 04:39:54 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_list.h"
#include "kvi_kvs_report.h"
#include "kvi_qstring.h"

class KVIRC_API KviKvsReportTarget
{
public:
	KviKvsReportTarget();
	~KviKvsReportTarget();
protected:
	KviPtrList<KviKvsReport> * m_pReportList;        // owned, may be 0!
	bool                       m_bError;
	const QChar              * m_pDefaultLocation;
public:
	// returns true if the report list contains an error (that's critical!)
	bool error(){ return m_bError; };
	// the whole error/warning list
	KviPtrList<KviKvsReport> * reportList(){ return m_pReportList; }; // may be 0!
	// pErrorPoint may be 0: in this case no location is defined
	void error(const QChar * pLocation,const QString &szMessageFmt,...);
	// same as above but it is intended to be not critical
	void warning(const QChar * pLocation,const QString &szMessageFmt,...);
	// sets the default report location for the two functions below
	void setDefaultReportLocation(const QChar * pLocation);
	// these two use the default location
	void error(const QString &szMsgFmt,...);
	void warning(const QString &szMsgFmt,...);
	// this is a really common compile time error
	void errorBadChar(const QChar * pLocation,char cExpected,const char * szCommandName);
	// really common runtime errors and warnings
	bool errorNoIrcContext();
	bool warningNoIrcConnection();
	bool warningMissingParameter();
protected:
	void report(KviKvsReport::Type t,const QChar * pLocation,const QString &szMessageFmt,kvi_va_list va);
};

#endif //!_KVI_KVS_REPORTTARGET_H_
