//=============================================================================
//
//   File : kvi_kvs_treenode_arrayelement.cpp
//   Created on Tue 07 Oct 2003 02:58:41 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_arrayelement.h"
#include "kvi_kvs_runtimecontext.h"
#include "kvi_locale.h"
#include "kvi_kvs_array.h"

KviKvsTreeNodeArrayElement::KviKvsTreeNodeArrayElement(const QChar * pLocation,KviKvsTreeNodeData * pSource,KviKvsTreeNodeExpression * pIndex)
: KviKvsTreeNodeArrayOrHashElement(pLocation,pSource)
{
	m_pIndex = pIndex;
	m_pIndex->setParent(this);
}


KviKvsTreeNodeArrayElement::~KviKvsTreeNodeArrayElement()
{
	delete m_pIndex;
}

void KviKvsTreeNodeArrayElement::dump(const char * prefix)
{
	debug("%s ArrayElement",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	m_pSource->dump(tmp.latin1());
	m_pIndex->dump(tmp.latin1());
}

bool KviKvsTreeNodeArrayElement::evaluateReadOnly(KviKvsRunTimeContext * c,KviKvsVariant * pBuffer)
{
	KviKvsVariant idx;
	if(!m_pIndex->evaluateReadOnly(c,&idx))return 0;


	int iVal;
	if(!idx.asInteger(iVal))
	{
		c->error(location(),__tr2qs("Array index didn't evaluate to an integer"));
		pBuffer->setNothing();
		return true;
	}

	if(iVal < 0)
	{
		c->error(location(),__tr2qs("Array index evaluated to a negative integer (non negative integer expected)"));
		pBuffer->setNothing();
		return true;
	}

	KviKvsVariant val;
	m_pSource->evaluateReadOnly(c,&val);

	if(!val.isArray())
	{
		if(!val.isNothing())
		{
			QString szType;
			val.getTypeName(szType);
			c->warning(location(),__tr2qs("The argument of the [] subscript didn't evaluate to an array: automatic conversion from %Q supplied"),&szType);
		}
		pBuffer->setNothing();
		return true;
	}

	KviKvsVariant * v = val.array()->find(iVal);
	if(!v)
	{
		pBuffer->setNothing();
		return true;
	}

	pBuffer->copyFrom(v);
	return true;
}

KviKvsRWEvaluationResult * KviKvsTreeNodeArrayElement::evaluateReadWrite(KviKvsRunTimeContext * c)
{
	KviKvsVariant idx;
	if(!m_pIndex->evaluateReadOnly(c,&idx))return 0;
	
	int iVal;
	if(!idx.asInteger(iVal))
	{
		c->error(location(),__tr2qs("Array index didn't evaluate to an integer"));
		return 0;
	}

	if(iVal < 0)
	{
		c->error(location(),__tr2qs("Array index evaluated to a negative integer (non negative integer expected)"));
		return 0;
	}

	KviKvsRWEvaluationResult * result = m_pSource->evaluateReadWrite(c);
	if(!result)return 0;

	if(!result->result()->isArray())
	{
		// convert to hash in some way
		if(!result->result()->isNothing())
		{
			QString szType;
			result->result()->getTypeName(szType);
			c->warning(location(),__tr2qs("The argument of the [] subscript didn't evaluate to an array: automatic conversion from type '%Q' supplied"),&szType);
		}
		result->result()->setArray(new KviKvsArray());
	}

	return new KviKvsArrayElement(result,result->result()->array()->get(iVal),result->result()->array(),iVal);
}
