//=============================================================================
//
//   File : kvi_kvs_treenode_hashelement.cpp
//   Created on Tue 07 Oct 2003 03:04:18 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_hashelement.h"
#include "kvi_kvs_runtimecontext.h"
#include "kvi_locale.h"
#include "kvi_kvs_hash.h"

KviKvsTreeNodeHashElement::KviKvsTreeNodeHashElement(const QChar * pLocation,KviKvsTreeNodeData * pSource,KviKvsTreeNodeData * pKey)
: KviKvsTreeNodeArrayOrHashElement(pLocation,pSource)
{
	m_pKey = pKey;
	m_pKey->setParent(this);
}


KviKvsTreeNodeHashElement::~KviKvsTreeNodeHashElement()
{
	delete m_pKey;
}

void KviKvsTreeNodeHashElement::dump(const char * prefix)
{
	debug("%s HashElement",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	m_pSource->dump(tmp.latin1());
	m_pKey->dump(tmp.latin1());
}

/*
bool KviKvsTreeNodeHashElement::evaluate(KviKvsRunTimeContext * c)
{
	if(!m_pSource->evaluate(c))return false;
	if(!m_pKey->evaluate(c))return false;
	
	m_pValue = m_pSource->result();

	QString szKey;
	m_pKey->result()->asString(szKey);

	if(szKey.isEmpty())
	{
		c->warning(location(),__tr2qs("Hash key evaluated to empty string: fix the script"));
	}

	if(!m_pValue->isHash())
	{
		// convert to hash in some way
#warning "Supply a *real* conversion from other types to hash ?"
		if(!m_pValue->isNothing())
		{
			QString szType;
			m_pValue->getTypeName(szType);
			c->warning(location(),__tr2qs("The argument of the {} subscript didn't evaluate to a hash: automatic conversion from %Q supplied"),&szType);
		}
	
		m_pValue->setHash(new KviKvsHash());
	}
	
	m_pValue = m_pValue->hash()->get(szKey);
	return true;
}
*/

bool KviKvsTreeNodeHashElement::evaluateReadOnly(KviKvsRunTimeContext * c,KviKvsVariant * pBuffer)
{
	KviKvsVariant key;
	if(!m_pKey->evaluateReadOnly(c,&key))return 0;

	QString szKey;
	key.asString(szKey);

	if(szKey.isEmpty())
	{
		c->warning(location(),__tr2qs("Hash key evaluated to empty string: fix the script"));
		pBuffer->setNothing();
		return true;
	}

	KviKvsVariant val;
	m_pSource->evaluateReadOnly(c,&val);

	if(!val.isHash())
	{
		if(!val.isNothing())
		{
			QString szType;
			val.getTypeName(szType);
			c->warning(location(),__tr2qs("The argument of the {} subscript didn't evaluate to a hash: automatic conversion from type '%Q' supplied"),&szType);
		}
		pBuffer->setNothing();
		return true;
	}

	KviKvsVariant * v = val.hash()->find(szKey);
	if(!v)
	{
		pBuffer->setNothing();
		return true;
	}

	pBuffer->copyFrom(v);
	return true;
}

KviKvsRWEvaluationResult * KviKvsTreeNodeHashElement::evaluateReadWrite(KviKvsRunTimeContext * c)
{
	KviKvsVariant key;
	if(!m_pKey->evaluateReadOnly(c,&key))return 0;

	QString szKey;
	key.asString(szKey);

	if(szKey.isEmpty())
	{
		c->warning(location(),__tr2qs("Hash key evaluated to empty string: fix the script"));
	}

	KviKvsRWEvaluationResult * result = m_pSource->evaluateReadWrite(c);
	if(!result)return 0;

	if(!result->result()->isHash())
	{
		// convert to hash in some way
//#warning "Supply a *real* conversion from other types to array ?"
		if(!result->result()->isNothing())
		{
			QString szType;
			result->result()->getTypeName(szType);
			c->warning(location(),__tr2qs("The argument of the {} subscript didn't evaluate to a hash automatic conversion from %Q supplied"),&szType);
		}
		result->result()->setHash(new KviKvsHash());
	}

	return new KviKvsHashElement(result,result->result()->hash()->get(szKey),result->result()->hash(),szKey);
}


