//=============================================================================
//
//   File : kvi_kvs_treenode_hashreferenceassert.cpp
//   Created on Thu 16 Oct 2003 23:43:06 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_hashreferenceassert.h"
#include "kvi_kvs_rwevaluationresult.h"
#include "kvi_kvs_runtimecontext.h"
#include "kvi_kvs_variant.h"
#include "kvi_locale.h"

KviKvsTreeNodeHashReferenceAssert::KviKvsTreeNodeHashReferenceAssert(const QChar * pLocation,KviKvsTreeNodeData * pSource)
: KviKvsTreeNodeIndirectData(pLocation,pSource)
{
}

KviKvsTreeNodeHashReferenceAssert::~KviKvsTreeNodeHashReferenceAssert()
{
}


void KviKvsTreeNodeHashReferenceAssert::dump(const char * prefix)
{
	debug("%s HashReferenceAssert",prefix);
}

bool KviKvsTreeNodeHashReferenceAssert::evaluateReadOnly(KviKvsRunTimeContext * c,KviKvsVariant * pBuffer)
{
	if(!m_pSource->evaluateReadOnly(c,pBuffer))return false;
	
	if(!pBuffer->isHash())
	{
		if(!pBuffer->isNothing())
		{
			QString szType;
			pBuffer->getTypeName(szType);
			c->error(location(),__tr2qs("Hash reference assert failed: the variable evaluated to type '%Q'"),&szType);
			return false;
		}
	}
	
	return true;
}

KviKvsRWEvaluationResult * KviKvsTreeNodeHashReferenceAssert::evaluateReadWrite(KviKvsRunTimeContext * c)
{
	KviKvsRWEvaluationResult * r = m_pSource->evaluateReadWrite(c);
	if(!r)return false;
	
	if(!(r->result()->isHash()))
	{
		if(!(r->result()->isNothing()))
		{
			QString szType;
			r->result()->getTypeName(szType);
			c->error(location(),__tr2qs("Hash reference assert failed: the variable evaluated to type '%Q'"),&szType);
			delete r;
			return false;
		}
	}
	
	return r;
}
