#ifndef _KVI_TIMERMANAGER_H_
#define _KVI_TIMERMANAGER_H_
//
//   File : kvi_timermanager.h
//   Creation date : Wed Aug 29 15:33:35 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_string.h"

#include <qobject.h>
#include <qintdict.h>
#include <qasciidict.h>

class KviWindow;
class KviParameterList;
class KviTimerManager;
class KviDataContainer;

#define KVI_USER_TIMER_FLAG_SINGLE_SHOT 1
#define KVI_USER_TIMER_FLAG_PERSISTENT 2

class KVIRC_API KviUserTimer
{
	friend class KviTimerManager;
protected:
	KviUserTimer();
public:
	~KviUserTimer();
protected:
	KviWindow        * m_pWnd;
	KviStr             m_szName;
	KviStr             m_szCmd;
	int                m_iDelay;
	unsigned int       m_uFlags;
	int                m_iId;
	KviParameterList * m_pParams;
	KviDataContainer * m_pDataContainer;
};



class KVIRC_API KviTimerManager : public QObject
{
	Q_OBJECT
public:
	KviTimerManager();
	~KviTimerManager();
private:
	QIntDict<KviUserTimer>   * m_pTimerDict;      // stored by id
	QAsciiDict<KviUserTimer> * m_pAsciiTimerDict; // stored by name
	int tickTimer;
public:
	bool addTimer(KviStr & name,KviWindow * pWnd,KviStr &szCmd,KviParameterList * params,int iDelay,unsigned int uFlags);
	bool delTimer(const char * name);
	bool isTimer(const char * name);
protected:
	virtual void timerEvent(QTimerEvent *e);
};




#endif //_KVI_TIMERMANAGER_H_
