//
//   File : logviewmdiwindow.cpp
//   Creation date : Tue Apr 23 2002 18:08:22 by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "logviewmdiwindow.h"
#include "logviewwidget.h"
#include "kvi_iconmanager.h"
#include "kvi_locale.h"
#include "kvi_module.h"
#include "kvi_options.h"

extern KviLogViewMDIWindow * g_pLogViewWindow;

KviLogViewMDIWindow::KviLogViewMDIWindow(KviModuleExtensionDescriptor * d,KviFrame * lpFrm)
: KviWindow(KVI_WINDOW_TYPE_LOGVIEW,lpFrm,"logview"), KviModuleExtension(d)
{
	g_pLogViewWindow = this;
	m_pLogViewWidget = new KviLogViewWidget(this);
}



KviLogViewMDIWindow::~KviLogViewMDIWindow()
{
    g_pLogViewWindow = 0;
}

QPixmap * KviLogViewMDIWindow::myIconPtr()
{
    return g_pIconManager->getSmallIcon(KVI_SMALLICON_LOG);
}


void KviLogViewMDIWindow::resizeEvent(QResizeEvent *e)
{
    m_pLogViewWidget->setGeometry(0,0,width(),height());
}

void KviLogViewMDIWindow::fillCaptionBuffers()
{
	m_szPlainTextCaption = __tr2qs_ctx("Log Viewer","logview");

	m_szHtmlActiveCaption = QString("<nobr><font color=\"%1\"><b>").arg(KVI_OPTION_COLOR(KviOption_colorCaptionTextActive).name().ascii());
	m_szHtmlActiveCaption.append(m_szPlainTextCaption);
	m_szHtmlActiveCaption.append("</b></font></nobr>");

	m_szHtmlInactiveCaption = QString("<nobr><font color=\"%1\"><b>").arg(KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive).name().ascii());
	m_szHtmlInactiveCaption.append(m_szPlainTextCaption);
	m_szHtmlInactiveCaption.append("</b></font></nobr>");
}

void KviLogViewMDIWindow::die()
{
	close();
}

#include "logviewmdiwindow.moc"

