//
//   File : class_button.cpp
//   Creation date : Wed 13 Sep 2000 02:42:05 CEST by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_debug.h"
#include "kvi_scriptobject.h"
#include "kvi_command.h"
#include "kvi_error.h"

#include "class_button.h"

static KviScriptObjectClass * g_pButtonClass = 0;

static KviScriptObject * buttonClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptButtonObject(c, p, n);
}

KviScriptButtonObject::KviScriptButtonObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char * n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptButtonObject::~KviScriptButtonObject()
{
//	debug("KviScriptButtonObject::~KviScriptButtonObject(%s)",id());
}

//#warning "Button DOCS"
//#warning "SLOTS - need a HOWTO :("

/*
	@doc: button
	@keyterms:
		button object class
	@title:
		button class
	@type:
		class
	@short:
		A simple, well-known button
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		A button - nothing more, nothing else...
	@functions:
		!fn: $setText(<text>)
		This function sets the text for this button.[br]
		!fn: $text()
		Returns the current text of the button
		!fn: $clickEvent()
		This function is called by the framework when the button is clicked.[br]
		You can reimplement it to handle the user click events.[br]
		The default implementation emits the [classfnc]$clicked[/classfnc]() signal,
		so it is easy to handle the clicks from many buttons without reimplementing
		the $clickEvent() for every one.[br]
		Note:[br]
		If you reimplement this function to catch the user click events, you will have
		to emit the signal by yourself (if you still need it , obviously).[br]
	@signals:
		!sg: $clicked()
		This signal is emitted by the default implementation of [classfnc]clickEvent[/classfnc]().[br]
		If you reimplement that function you will have to emit the signal manually (if you still need it).[br]

*/

bool KviScriptButtonObject::init(KviCommand *)
{
	setObject(new QPushButton(parentScriptWidget(),name()),true);
	connect(widget(),SIGNAL(clicked()),this,SLOT(slotClicked()));
	return true;
}

#define buttonFuncReg(__nam, __func) \
	g_pButtonClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptButtonObject::__func)), \
	0, true);

void KviScriptButtonObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController->
		lookupClass("widget");
	__range_valid(base);

	g_pButtonClass = new KviScriptObjectClass(base, "button", 
		buttonClassCreateInstance, true);

	buttonFuncReg("setText", functionSetText);
	buttonFuncReg("text", functionText);
	buttonFuncReg("setAutoDefault", functionSetAutoDefault);
	buttonFuncReg("setToggleButton", functionSetToggleButton);
	buttonFuncReg("setOn", functionSetOn);
	buttonFuncReg("isOn", functionIsOn);
	buttonFuncReg("toggle", functionToggle);
	buttonFuncReg("setIsMenuButton", functionSetIsMenuButton);
	buttonFuncReg("isMenuButton", functionIsMenuButton);
	buttonFuncReg("clickEvent", functionClickEvent);

//	g_pButtonClass->registerFunctionHandler("clickEvent",0,"emit clicked()");
// slots
//	buttonFuncReg("slotClicked", functionSlotClicked);
//	buttonFuncReg("slotClicked", __slotClicked);
	//g_pButtonClass->registerEmptyFunctionHandler("slotClicked");
}

void KviScriptButtonObject::unregisterSelf()
{
	delete g_pButtonClass;
    g_pButtonClass = 0;
}

bool KviScriptButtonObject::functionSetText(KviCommand *, KviParameterList * p, \
	KviStr &)
{
	if(widget())
	{
		if(p->first())
			((QPushButton *)widget())->setText(p->first()->ptr());
		else
			((QPushButton *)widget())->setText("");
	}
	return true;
}

bool KviScriptButtonObject::functionText(KviCommand *, KviParameterList *, KviStr & b)
{
	if(widget())
	{
		KviStr s = ((QPushButton *)widget())->text();
		b.append(s);
	}
	return true;
}

bool KviScriptButtonObject::functionSetAutoDefault(KviCommand *, KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->setAutoDefault(p->getBool());
	}
	return true;
}

bool KviScriptButtonObject::functionSetToggleButton(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->setToggleButton(p->getBool());
	}
	return true;
}

bool KviScriptButtonObject::functionSetOn(KviCommand *,KviParameterList * p, KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->setOn(p->getBool());
	}
	return true;
}

bool KviScriptButtonObject::functionIsOn(KviCommand *, KviParameterList *, KviStr & b)
{
	if(widget())
	{
		bool t = ((QPushButton *)widget())->isOn();
		b.append( t ? '1' : '0' );
	}
	return true;
}

bool KviScriptButtonObject::functionToggle(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->toggle();
	}
	return true;
}

bool KviScriptButtonObject::functionSetIsMenuButton(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->setIsMenuButton(p->getBool());
	}
	return true;
}

bool KviScriptButtonObject::functionIsMenuButton(KviCommand *,KviParameterList *,
	KviStr & b)
{
	if(widget())
	{
		bool t = ((QPushButton *)widget())->isMenuButton();
		b.append( t ? '1' : '0' );
	}
	return true;
}
/*
bool KviScriptButtonObject::functionSlotClicked(KviCommand * c, KviParameterList * p, 
	KviStr & b)
{
	debug("KviScriptButtonObject::functionSlotClicked");
	
	return true;
}
*/

bool KviScriptButtonObject::functionClickEvent(KviCommand *c,KviParameterList *,KviStr &)
{
	ENTER_STACK_FRAME(c,"button::clickEvent");
	emitSignal("clicked",0,0,c);
	return c->leaveStackFrame();
}

void KviScriptButtonObject::slotClicked()
{
	callEventFunction("clickEvent");
}
/*
void KviScriptButtonObject::__slotToggled()
{
}
*/
#include "m_class_button.moc"
