//
//   File : class_menubar.cpp
//   Creation date : Tue Now 26 13:16:59 CEST 2002 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include "class_menubar.h"
//#include "kvi_fileutils.h"
#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"

static KviScriptObjectClass * g_pMenuBarClass = 0;

static KviScriptObject * menuBarClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptMenuBarObject(c, p, n);
}

KviScriptMenuBarObject::KviScriptMenuBarObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptMenuBarObject::~KviScriptMenuBarObject()
{
}

/*
	@doc:	menubar
	@title:
		menubar class
	@type:
		class
	@short:
		A menu bar object implementation
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		
	@functions:
		!fn: $insertItem(<text>,<popup>)
		Returns an integer that identifies the inserted item.
*/

bool KviScriptMenuBarObject::init(KviCommand *)
{
	setObject(new QMenuBar(parentScriptWidget(), name()));
	return true;
}

#define menuBarFuncReg(__nam, __func) \
	g_pMenuBarClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptMenuBarObject::__func)), \
	0, true);

void KviScriptMenuBarObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pMenuBarClass = new KviScriptObjectClass(base, "menubar",
		menuBarClassCreateInstance, true);

	menuBarFuncReg("insertItem", functionInsertItem);
}

void KviScriptMenuBarObject::unregisterSelf()
{
	delete g_pMenuBarClass;
    g_pMenuBarClass = 0;
}

bool KviScriptMenuBarObject::functionInsertItem(KviCommand * c,KviParameterList * p,KviStr & b)
{
	ENTER_STACK_FRAME(c,"menubar::insertItem");

	KviStr * pText = p->safeFirst();
	//KviStr * pMenu = p->safeNext();

	if(widget())((QMenuBar *)widget())->insertItem(pText->ptr());

	return c->leaveStackFrame();
}



#include "m_class_menubar.moc"
