//
//   File : optw_defmessages.cpp
//   Creation date : Fri Aug 23 02:30:51 2002 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "optw_defmessages.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"



KviDefaultMessagesOptionsWidget::KviDefaultMessagesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"defaultmessages_options_widget")
{
	createLayout(3,1);

	KviStringSelector * s = addStringSelector(0,0,0,0, __tr2qs("Default part message:"),KviOption_stringPartMessage);

#ifdef COMPILE_INFO_TIPS
	mergeTip(s,
		__tr2qs("<center>This is the default part message that will be used when you<br>" \
				"leave a channel by closing a channel window.</center>"));
#endif

	s = addStringSelector(0,1,0,1, __tr2qs("Default quit message:"),KviOption_stringQuitMessage);

#ifdef COMPILE_INFO_TIPS
	mergeTip(s,
		__tr2qs("<center>This is the default quit message that will be used when you<br>" \
			"quit your IRC session by closing the console window or disconnecting by pressing the disconnect button.</center>"));
#endif

	addRowSpacer(0,2,0,2);
}

KviDefaultMessagesOptionsWidget::~KviDefaultMessagesOptionsWidget()
{
}

#include "m_optw_defmessages.moc"
