//
//   File : optw_ircoutput.cpp
//   Creation date : Wed Nov 15 2000 11:45:06 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_ircoutput.h"

#include <qlayout.h>

#include "kvi_settings.h"
#include "kvi_options.h"
#include "kvi_locale.h"

#include <qcombobox.h>
#include <qlabel.h>

#ifdef COMPILE_INFO_TIPS
	#include <qtooltip.h>
#endif

KviIrcOutputOptionsWidget::KviIrcOutputOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircoutput_options_widget")
{
	createLayout(8,2);

	QLabel * l =new QLabel(__tr2qs("Output verbosity"),this);
	addWidgetToLayout(l,0,0,0,0);

	m_pVerbosityCombo = new QComboBox(false,this);
	addWidgetToLayout(m_pVerbosityCombo,1,0,1,0);
	
	m_pVerbosityCombo->insertItem(__tr2qs("Mute"));
	m_pVerbosityCombo->insertItem(__tr2qs("Quiet"));
	m_pVerbosityCombo->insertItem(__tr2qs("Normal"));
	m_pVerbosityCombo->insertItem(__tr2qs("Verbose"));
	m_pVerbosityCombo->insertItem(__tr2qs("Paranoic"));

	if(KVI_OPTION_UINT(KviOption_uintOutputVerbosityLevel) > KVI_VERBOSITY_LEVEL_PARANOIC)
		KVI_OPTION_UINT(KviOption_uintOutputVerbosityLevel) = KVI_VERBOSITY_LEVEL_NORMAL;
	m_pVerbosityCombo->setCurrentItem(KVI_OPTION_UINT(KviOption_uintOutputVerbosityLevel));

	QGroupBox * g = addGroupBox(0,1,1,1,1,QGroupBox::Horizontal,__tr2qs("Show in active window"));
	addBoolSelector(g,__tr2qs("External messages"),KviOption_boolExternalMessagesToActiveWindow);
	addBoolSelector(g,__tr2qs("External CTCP replies"),KviOption_boolCtcpRepliesToActiveWindow);
	addBoolSelector(g,__tr2qs("Whois replies"),KviOption_boolWhoisRepliesToActiveWindow);
	addBoolSelector(g,__tr2qs("ChanServ and NickServ notices"),KviOption_boolServicesNoticesToActiveWindow);
	addBoolSelector(g,__tr2qs("Invite messages"),KviOption_boolInvitesToActiveWindow);
	addBoolSelector(g,__tr2qs("Server replies"),KviOption_boolServerRepliesToActiveWindow);
	addBoolSelector(g,__tr2qs("Server notices"),KviOption_boolServerNoticesToActiveWindow);
	addBoolSelector(g,__tr2qs("Broadcast and WALLOPS messages"),KviOption_boolOperatorMessagesToActiveWindow);
	addBoolSelector(0,2,1,2,__tr2qs("Show extended server information"),KviOption_boolShowExtendedServerInfo);
	addBoolSelector(0,3,1,3,__tr2qs("Show server pings"),KviOption_boolShowPingPong);
	addBoolSelector(0,4,1,4,__tr2qs("Show own parts in the console"),KviOption_boolShowOwnParts);
	addBoolSelector(0,5,1,5,__tr2qs("Show compact mode changes"),KviOption_boolShowCompactModeChanges);
	g = addGroupBox(0,6,1,6,1,QGroupBox::Horizontal,__tr2qs("On Channel Join"));
	addBoolSelector(g,__tr2qs("Echo channel topic"),KviOption_boolEchoNumericTopic);
	addBoolSelector(g,__tr2qs("Show channel sync time"),KviOption_boolShowChannelSyncTime);
	addRowSpacer(0,7,1,7);
}

KviIrcOutputOptionsWidget::~KviIrcOutputOptionsWidget()
{
}

void KviIrcOutputOptionsWidget::commit()
{
	KviOptionsWidget::commit();
	
	int i = m_pVerbosityCombo->currentItem();
	if((i < 0) || (i > KVI_VERBOSITY_LEVEL_PARANOIC))i = KVI_VERBOSITY_LEVEL_NORMAL;
	KVI_OPTION_UINT(KviOption_uintOutputVerbosityLevel) = i;
}

#include "m_optw_ircoutput.moc"
