//
//   File : optw_mediatypes.cpp
//   Creation date : Sat Jan 20 2001 16:14:53 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_mediatypes.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>

#include "kvi_options.h"
#include "kvi_locale.h"

// kvi_app.cpp
extern KVIRC_API KviMediaManager * g_pMediaManager;

static void copyMediaType(KviMediaType * dst,const KviMediaType * src)
{
	dst->szFileMask              = src->szFileMask;
	dst->szIanaType              = src->szIanaType;
	dst->szDescription           = src->szDescription;
	dst->szMagicBytes            = src->szMagicBytes;
	dst->szSavePath              = src->szSavePath;
	dst->szCommandline           = src->szCommandline;
	dst->szRemoteExecCommandline = src->szRemoteExecCommandline;
	dst->szIcon                  = src->szIcon;
}

KviMediaTypeListViewItem::KviMediaTypeListViewItem(QListView * w,KviMediaType * t)
: QListViewItem(w)
{
	copyData(t);
}

KviMediaTypeListViewItem::~KviMediaTypeListViewItem()
{
}

void KviMediaTypeListViewItem::copyData(KviMediaType * t)
{
	copyMediaType(&m_data,t);
	setText(0,m_data.szFileMask.ptr());
	setText(1,m_data.szIanaType.ptr());
	setText(2,m_data.szDescription.ptr());	
}

KviMediaTypesOptionsWidget::KviMediaTypesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"mediatypes_options_widget")
{
	createLayout(11,3);

	m_pListView = new QListView(this);
	m_pListView->addColumn(__tr2qs("Pattern"));
	m_pListView->addColumn(__tr2qs("MIME Type"));
	m_pListView->addColumn(__tr2qs("Description"));
	m_pListView->setAllColumnsShowFocus(true);



	connect(m_pListView,SIGNAL(currentChanged(QListViewItem *)),this,SLOT(currentItemChanged(QListViewItem *)));

	layout()->addMultiCellWidget(m_pListView,0,0,0,2);

	QLabel * l = new QLabel(__tr2qs("Description:"),this);
	layout()->addWidget(l,1,0);
	m_pDescription = new QLineEdit(this);
	layout()->addMultiCellWidget(m_pDescription,1,1,1,2);

	l = new QLabel(__tr2qs("MIME type:"),this);
	layout()->addWidget(l,2,0);
	m_pIanaType = new QLineEdit(this);
	layout()->addMultiCellWidget(m_pIanaType,2,2,1,2);

	l = new QLabel(__tr2qs("File pattern:"),this);
	layout()->addWidget(l,3,0);
	m_pFileMask = new QLineEdit(this);
	layout()->addMultiCellWidget(m_pFileMask,3,3,1,2);

	l = new QLabel(__tr2qs("Magic bytes:"),this);
	layout()->addWidget(l,4,0);
	m_pMagicBytes = new QLineEdit(this);
	layout()->addMultiCellWidget(m_pMagicBytes,4,4,1,2);

	l = new QLabel(__tr2qs("Save path:"),this);
	layout()->addWidget(l,5,0);
	m_pSavePath = new QLineEdit(this);
	layout()->addMultiCellWidget(m_pSavePath,5,5,1,2);

	l = new QLabel(__tr2qs("Local open command:"),this);
	layout()->addWidget(l,6,0);
	m_pCommandline = new QLineEdit(this);
	layout()->addMultiCellWidget(m_pCommandline,6,6,1,2);
#ifdef COMPILE_INFO_TIPS
	mergeTip(m_pCommandline,__tr2qs("<center>This field contains the command to execute to open a local file.<br>" \
		"<tt>$0</tt> is used in place of the filename</center>"));
#endif

	l = new QLabel(__tr2qs("Remote open command:"),this);
	layout()->addWidget(l,7,0);
	m_pRemoteExecCommandline = new QLineEdit(this);
	layout()->addMultiCellWidget(m_pRemoteExecCommandline,7,7,1,2);
#ifdef COMPILE_INFO_TIPS
	mergeTip(m_pRemoteExecCommandline,__tr2qs("<center>This field contains the command to execute when automatically opening a received file.<br>" \
		"<tt>$0</tt> is used in place of the filename</center>"));
#endif

	l = new QLabel(__tr2qs("Icon"),this);
	layout()->addWidget(l,8,0);
	m_pIcon = new QLineEdit(this);
	layout()->addMultiCellWidget(m_pIcon,8,8,1,2);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	layout()->addMultiCellWidget(f,9,9,0,2);

	QPushButton * b = new QPushButton(__tr2qs("&New"),this);
	connect(b,SIGNAL(clicked()),this,SLOT(newMediaType()));
	layout()->addWidget(b,10,1);

	m_pDelete = new QPushButton(__tr2qs("Re&move"),this);
	connect(m_pDelete,SIGNAL(clicked()),this,SLOT(delMediaType()));
	layout()->addWidget(m_pDelete,10,2);
	

	layout()->setColStretch(1,1);
	layout()->setColStretch(2,1);
	layout()->setRowStretch(0,1);

	m_pLastItem = 0;

	fillListView();
}

KviMediaTypesOptionsWidget::~KviMediaTypesOptionsWidget()
{
}

void KviMediaTypesOptionsWidget::fillListView()
{
	m_pListView->clear();
	g_pMediaManager->lock();
	KviPtrList<KviMediaType> * l = g_pMediaManager->mediaTypeList();
	KviMediaTypeListViewItem * it;
	for(KviMediaType * t = l->first();t;t = l->next())
	{
		it = new KviMediaTypeListViewItem(m_pListView,t);
	}
	g_pMediaManager->unlock();
	enableOrDisable();
}

void KviMediaTypesOptionsWidget::saveLastItem()
{
	if(m_pLastItem)
	{
		KviMediaType t;
		t.szDescription           = m_pDescription->text();
		t.szIanaType              = m_pIanaType->text();
		t.szFileMask              = m_pFileMask->text();
		t.szSavePath              = m_pSavePath->text();
		t.szCommandline           = m_pCommandline->text();
		t.szMagicBytes            = m_pMagicBytes->text();
		t.szRemoteExecCommandline = m_pRemoteExecCommandline->text();
		t.szIcon                  = m_pIcon->text();

		if(t.szDescription.isEmpty())t.szDescription = __tr2qs("[Unknown Media Type]");

		m_pLastItem->copyData(&t);
	}
}

void KviMediaTypesOptionsWidget::enableOrDisable()
{
	m_pDescription->setEnabled(m_pLastItem);
	m_pIanaType->setEnabled(m_pLastItem);
	m_pFileMask->setEnabled(m_pLastItem);
	m_pSavePath->setEnabled(m_pLastItem);
	m_pCommandline->setEnabled(m_pLastItem);
	m_pMagicBytes->setEnabled(m_pLastItem);
	m_pRemoteExecCommandline->setEnabled(m_pLastItem);
	m_pDelete->setEnabled(m_pLastItem);
	m_pIcon->setEnabled(m_pLastItem);
}

void KviMediaTypesOptionsWidget::setLineEdits()
{
	m_pDescription->setText(m_pLastItem ? m_pLastItem->data()->szDescription.ptr() : "");
	m_pIanaType->setText(m_pLastItem ? m_pLastItem->data()->szIanaType.ptr() : "");
	m_pFileMask->setText(m_pLastItem ? m_pLastItem->data()->szFileMask.ptr() : "");
	m_pSavePath->setText(m_pLastItem ? m_pLastItem->data()->szSavePath.ptr() : "");
	m_pCommandline->setText(m_pLastItem ? m_pLastItem->data()->szCommandline.ptr() : "");
	m_pMagicBytes->setText(m_pLastItem ? m_pLastItem->data()->szMagicBytes.ptr() : "");
	m_pRemoteExecCommandline->setText(m_pLastItem ? m_pLastItem->data()->szRemoteExecCommandline.ptr() : "");
	m_pIcon->setText(m_pLastItem ? m_pLastItem->data()->szIcon.ptr() : "");
}

void KviMediaTypesOptionsWidget::currentItemChanged(QListViewItem *it)
{
	saveLastItem();
	m_pLastItem = (KviMediaTypeListViewItem *)it;
	if(it)
	{
		if(!it->isSelected())m_pListView->setSelected(it,true);
	}
	setLineEdits();
	enableOrDisable();
}

void KviMediaTypesOptionsWidget::newMediaType()
{
	KviMediaType empty;
	empty.szDescription = __tr2qs("New Media Type");
	KviMediaTypeListViewItem * it = new KviMediaTypeListViewItem(m_pListView,&empty);
	m_pListView->setCurrentItem(it);
	m_pListView->setSelected(it,true);
}

void KviMediaTypesOptionsWidget::delMediaType()
{
	if(m_pLastItem)
	{
		KviMediaTypeListViewItem * it = m_pLastItem;
		m_pLastItem = 0;
		delete it;
	}
}

void KviMediaTypesOptionsWidget::commit()
{
	saveLastItem();
	KviMediaTypeListViewItem * it = (KviMediaTypeListViewItem *)m_pListView->firstChild();
	g_pMediaManager->lock();
	g_pMediaManager->clear();
	while(it)
	{
		KviMediaType * t = new KviMediaType;
		copyMediaType(t,it->data());
		g_pMediaManager->insertMediaType(t);
		it = (KviMediaTypeListViewItem *)it->nextSibling();
	}
	g_pMediaManager->unlock();
}

#include "m_optw_mediatypes.moc"
