//
//   File : optw_textencoding.cpp
//   Creation date : Sat Aug 11 2001 03:29:52 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_textencoding.h"

#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_qstring.h"


KviTextEncodingOptionsWidget::KviTextEncodingOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"textencoding_options_widget")
{
	createLayout(3,2);

	addLabel(0,0,0,0,__tr2qs("Default text encoding:"));

	m_pTextEncodingCombo = new QComboBox(this);
	addWidgetToLayout(m_pTextEncodingCombo,1,0,1,0);

	addRowSpacer(0,2,1,2);

	m_pTextEncodingCombo->insertItem(__tr2qs("Use Language Encoding"));
	int i = 0;
	int iMatch = 0;
	KviLocale::EncodingDescription * d = KviLocale::encodingDescription(i);
	while(d->szName)
	{
		if(KviQString::equalCI(d->szName,KVI_OPTION_STRING(KviOption_stringDefaultTextEncoding)))iMatch = i + 1;
		m_pTextEncodingCombo->insertItem(d->szName);
		i++;
		d = KviLocale::encodingDescription(i);
	}

	m_pTextEncodingCombo->setCurrentItem(iMatch);
}

KviTextEncodingOptionsWidget::~KviTextEncodingOptionsWidget()
{
}

void KviTextEncodingOptionsWidget::commit()
{
	int idx = m_pTextEncodingCombo->currentItem();
	if(idx <= 0)
	{
		// guess from locale
		KVI_OPTION_STRING(KviOption_stringDefaultTextEncoding) = "";
		return;
	}
	KVI_OPTION_STRING(KviOption_stringDefaultTextEncoding) = m_pTextEncodingCombo->text(idx);
}

#include "m_optw_textencoding.moc"
