#ifndef _EDITUSER_H_
#define _EDITUSER_H_
//=============================================================================
//
//   File : edituser.h
//   Creation date : Sun Dec 24 2000 15:16:17 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_string.h"
#include "kvi_regusersdb.h"
#include "kvi_selectors.h"

#include <qwidget.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qdict.h>
#include <qtabdialog.h>
#include <qtable.h>


class KviRegisteredUser;

class KviReguserPropertiesDialog : public QDialog
{
	Q_OBJECT
public:
	KviReguserPropertiesDialog(QWidget *p,QDict<QString> * dict);
	~KviReguserPropertiesDialog();
protected:
	QTable             * m_pTable;
	QDict<QString>     * m_pPropertyDict;
	QPushButton        * m_pDelButton;
	QPushButton        * m_pAddButton;
protected:
	void fillData();
protected slots:
	void okClicked();
	void addClicked();
	void delClicked();
};


class KviReguserMaskDialog : public QDialog
{
	Q_OBJECT
public:
	KviReguserMaskDialog(QWidget * p,KviIrcMask * m);
	~KviReguserMaskDialog();
protected:
	KviIrcMask * m_pMask;

	QLineEdit * m_pNickEdit;
	QLineEdit * m_pUserEdit;
	QLineEdit * m_pHostEdit;
protected slots:
	void okClicked();
};


class KviRegisteredUsersDialogItem : public QListViewItem
{
protected:
	KviRegisteredUser * m_pUser;
public:
	KviRegisteredUsersDialogItem(QListView * par,KviRegisteredUser * u)
	: QListViewItem(par,u->name()) , m_pUser(u)
	{
	}

	~KviRegisteredUsersDialogItem()
	{
	}

public:
	KviRegisteredUser * user(){ return m_pUser; };
	void setUser(KviRegisteredUser * u){ m_pUser = u; };
	virtual void paintCell(QPainter * p,const QColorGroup &cg,int column,int width,int align);

};


class KviRegisteredUserEntryDialog : public QTabDialog
{
	Q_OBJECT
public:
	KviRegisteredUserEntryDialog(QWidget * p,KviRegisteredUser * r,bool bModal = true);
	virtual ~KviRegisteredUserEntryDialog();
protected:
	KviRegisteredUser  * m_pUser;

	QLineEdit          * m_pNameEdit;

	QListBox           * m_pMaskListBox;

	QPushButton        * m_pDelMaskButton;
	QPushButton        * m_pEditMaskButton;
	QPushButton        * m_pAddMaskButton;

	QCheckBox          * m_pNotifyCheck;
	QLineEdit          * m_pNotifyNick;

	KviPixmap          * m_pAvatar;
	KviPixmapSelector  * m_pAvatarSelector;

	QDict<QString>     * m_pPropertyDict;
protected slots:
	void okClicked();
	void addMaskClicked();
	void delMaskClicked();
	void editMaskClicked();
	void editAllPropertiesClicked();
	void maskCurrentChanged(QListBoxItem *it);
};


class KviRegisteredUsersDialog : public QWidget
{
	Q_OBJECT
public:
	KviRegisteredUsersDialog(QWidget * par = 0);
	~KviRegisteredUsersDialog();
public:
	QListView   * m_pListView;
	QPushButton * m_pAddButton;
	QPushButton * m_pWizardAddButton;
	QPushButton * m_pRemoveButton;
	QPushButton * m_pEditButton;
	QPushButton * m_pImportButton;
	QPushButton * m_pExportButton;
protected slots:
	void itemPressed(QListViewItem *it,const QPoint &pnt,int c);
	void itemDoubleClicked(QListViewItem *it);
protected:
	void fillList();
protected:
	virtual void closeEvent(QCloseEvent *);
	void editItem(KviRegisteredUsersDialogItem * i);
protected slots:
	void cancelClicked();
	void okClicked();
	void addClicked();
	void removeClicked();
	void editClicked();
	void selectionChanged();
	void importClicked();
	void exportClicked();
	void addWizardClicked();
};

#endif //_EDITUSER_H_
